/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.query;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import za.co.cporm.model.CPHelper;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.query.DataFilterClause;
import za.co.cporm.model.query.DataFilterCriteria;
import za.co.cporm.model.query.DataFilterCriterion;
import za.co.cporm.model.query.QueryBuilder;
import za.co.cporm.model.util.CPOrmCursor;
import za.co.cporm.model.util.ContentResolverValues;
import za.co.cporm.model.util.CursorIterator;
import za.co.cporm.provider.util.UriMatcherHelper;

public class Select<T>
implements DataFilterClause {
    private final Class<T> dataObjectClass;
    private DataFilterCriteria filterCriteria;
    private List<String> sortingOrderList;

    private Select(Class<T> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
        this.sortingOrderList = new LinkedList<String>();
        this.filterCriteria = new DataFilterCriteria();
    }

    public static <T> Select<T> from(Class<T> dataObjectClass) {
        return new Select<T>(dataObjectClass);
    }

    public Select<T> where(DataFilterClause filterClause) {
        this.filterCriteria.addClause(filterClause);
        return this;
    }

    public Select<T> where(DataFilterClause filterClause, DataFilterClause.DataFilterConjunction conjunction) {
        this.filterCriteria.addClause(filterClause, conjunction);
        return this;
    }

    public Select<T> whereEquals(String column, Object value) {
        this.addClause(new DataFilterCriterion(column, DataFilterCriterion.DataFilterOperator.EQUAL, value), DataFilterClause.DataFilterConjunction.AND);
        return this;
    }

    public Select<T> whereLike(String column, Object value) {
        this.addClause(new DataFilterCriterion(column, DataFilterCriterion.DataFilterOperator.LIKE, value), DataFilterClause.DataFilterConjunction.AND);
        return this;
    }

    public DataFilterCriterion.Builder<Select<T>> and() {
        return new DataFilterCriterion.Builder<Select<T>>(this, DataFilterClause.DataFilterConjunction.AND);
    }

    public DataFilterCriterion.Builder<Select<T>> or() {
        return new DataFilterCriterion.Builder<Select<T>>(this, DataFilterClause.DataFilterConjunction.OR);
    }

    public DataFilterCriteria.Builder<Select<T>> openBracketAnd() {
        return new DataFilterCriteria.Builder<Select<T>>(this, DataFilterClause.DataFilterConjunction.AND);
    }

    public DataFilterCriteria.Builder<Select<T>> openBracketOr() {
        return new DataFilterCriteria.Builder<Select<T>>(this, DataFilterClause.DataFilterConjunction.OR);
    }

    public Select sortDesc(String column) {
        this.sortingOrderList.add(column + " DESC");
        return this;
    }

    public CPOrmCursor<T> queryAsCursor(Context context) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, this.dataObjectClass);
        QueryBuilder where = this.getWhereClause();
        QueryBuilder sort = this.buildSort();
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails);
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(itemUri, null, where.getQueryString(), where.getQueryArgsAsArray(context), sort.getQueryString());
        return new CPOrmCursor(tableDetails, cursor);
    }

    public Iterator<T> queryAsIterator(Context context) {
        CPOrmCursor<T> cursor = this.queryAsCursor(context);
        return new CursorIterator(cursor.getTableDetails(), (Cursor)cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> queryAsList(Context context) {
        ArrayList<T> resultList = new ArrayList<T>();
        try (CPOrmCursor<T> cursor = this.queryAsCursor(context);){
            while (cursor.moveToNext()) {
                resultList.add(cursor.inflate());
            }
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryAsCount(Context context) {
        try (CPOrmCursor<T> cursor = this.queryAsCursor(context);){
            int n = cursor.getCount();
            return n;
        }
    }

    public ContentResolverValues asContentResolverValue(Context context) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, this.dataObjectClass);
        QueryBuilder where = this.getWhereClause();
        QueryBuilder sort = this.buildSort();
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails);
        return new ContentResolverValues(itemUri, tableDetails.getColumnNames(), where.getQueryString(), where.getQueryArgsAsArray(context), sort.getQueryString());
    }

    private QueryBuilder buildSort() {
        QueryBuilder builder = new QueryBuilder();
        Iterator<String> sortIterator = this.sortingOrderList.iterator();
        while (sortIterator.hasNext()) {
            builder.append(sortIterator.next(), new Object[0]);
            if (!sortIterator.hasNext()) continue;
            builder.append(", ", new Object[0]);
        }
        return builder;
    }

    @Override
    public QueryBuilder getWhereClause() {
        return this.filterCriteria.getWhereClause();
    }

    @Override
    public void addClause(DataFilterClause clause, DataFilterClause.DataFilterConjunction conjunction) {
        this.filterCriteria.addClause(clause, conjunction);
    }

    public String toString() {
        return this.getWhereClause().toString();
    }
}

