/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.query;

import android.content.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import za.co.cporm.model.map.SqlColumnMappingFactory;
import za.co.cporm.model.util.ManifestHelper;

public class QueryBuilder {
    private final StringBuilder queryBuffer = new StringBuilder();
    private final List<Object> argsStore = new LinkedList<Object>();

    public void append(String query, Object ... args) {
        this.queryBuffer.append(query);
        for (Object arg : args) {
            this.argsStore.add(String.valueOf(arg));
        }
    }

    public void append(QueryBuilder queryBuilder) {
        this.queryBuffer.append(queryBuilder.getQueryString());
        this.argsStore.addAll(queryBuilder.getQueryArgs());
    }

    public String getQueryString() {
        StringBuilder queryString = new StringBuilder();
        queryString.append((CharSequence)this.queryBuffer);
        return queryString.toString();
    }

    public Collection<String> getQueryArgs(Context context) {
        SqlColumnMappingFactory columnMappingFactory = ManifestHelper.getMappingFactory(context);
        LinkedList<String> queryArgs = new LinkedList<String>();
        for (Object arg : this.argsStore) {
            Object argConverted = columnMappingFactory.findColumnMapping(arg.getClass()).toSqlType(arg);
            queryArgs.add(String.valueOf(argConverted));
        }
        return Collections.unmodifiableCollection(queryArgs);
    }

    private Collection<Object> getQueryArgs() {
        LinkedList<Object> queryArgs = new LinkedList<Object>();
        queryArgs.addAll(this.argsStore);
        return Collections.unmodifiableCollection(queryArgs);
    }

    public String[] getQueryArgsAsArray(Context context) {
        return this.getQueryArgs(context).toArray(new String[0]);
    }

    public String toString() {
        return this.getQueryString();
    }
}

