/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.map;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import za.co.cporm.model.map.SqlColumnMapping;
import za.co.cporm.model.map.types.BooleanType;
import za.co.cporm.model.map.types.CalendarType;
import za.co.cporm.model.map.types.DateType;
import za.co.cporm.model.map.types.DoubleType;
import za.co.cporm.model.map.types.FloatType;
import za.co.cporm.model.map.types.IntegerType;
import za.co.cporm.model.map.types.LongType;
import za.co.cporm.model.map.types.ShortType;
import za.co.cporm.model.map.types.StringType;
import za.co.cporm.model.map.types.UUIDType;

public class SqlColumnMappingFactory {
    private final List<SqlColumnMapping> columnMappings = new ArrayList<SqlColumnMapping>();

    public SqlColumnMappingFactory() {
        this.columnMappings.add(new BooleanType());
        this.columnMappings.add(new CalendarType());
        this.columnMappings.add(new DateType());
        this.columnMappings.add(new DoubleType());
        this.columnMappings.add(new FloatType());
        this.columnMappings.add(new IntegerType());
        this.columnMappings.add(new LongType());
        this.columnMappings.add(new ShortType());
        this.columnMappings.add(new StringType());
        this.columnMappings.add(new UUIDType());
    }

    public SqlColumnMapping findColumnMapping(Type fieldType) {
        for (SqlColumnMapping columnMapping : this.columnMappings) {
            if (!columnMapping.getJavaType().equals(fieldType)) continue;
            return columnMapping;
        }
        throw new IllegalArgumentException("No valid SQL mapping found for type " + fieldType);
    }
}

