/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.util;

import android.content.ContentValues;
import android.database.Cursor;
import android.os.Bundle;
import java.util.List;
import za.co.cporm.model.generate.TableDetails;

public class ModelInflater {
    public static Object deflateColumn(TableDetails tableDetails, TableDetails.ColumnDetails columnDetails, Object dataModelObject) {
        try {
            Object value = columnDetails.getColumnField().get(dataModelObject);
            if (value == null) {
                return null;
            }
            return columnDetails.getColumnTypeMapping().toSqlType(value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to access protected field, change the access level: " + columnDetails.getColumnName());
        }
    }

    public static ContentValues deflate(TableDetails tableDetails, Object dataModelObject) {
        List<TableDetails.ColumnDetails> columns = tableDetails.getColumns();
        int size = columns.size();
        ContentValues contentValues = new ContentValues(size);
        for (int i = 0; i < size; ++i) {
            TableDetails.ColumnDetails columnDetails = columns.get(i);
            if (columnDetails.isAutoIncrement()) continue;
            try {
                columnDetails.setContentValue(contentValues, dataModelObject);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to access protected field, change the access level: " + columnDetails.getColumnName());
            }
        }
        return contentValues;
    }

    public static ContentValues[] deflateAll(TableDetails tableDetails, Object ... dataModelObjects) {
        int i;
        List<TableDetails.ColumnDetails> columns = tableDetails.getColumns();
        ContentValues[] contentValuesArray = new ContentValues[dataModelObjects.length];
        int size = columns.size();
        for (i = 0; i < dataModelObjects.length; ++i) {
            contentValuesArray[i] = new ContentValues(size);
        }
        for (i = 0; i < size; ++i) {
            TableDetails.ColumnDetails columnDetails = columns.get(i);
            if (columnDetails.isAutoIncrement()) continue;
            int length = dataModelObjects.length;
            for (int j = 0; j < length; ++j) {
                try {
                    columnDetails.setContentValue(contentValuesArray[j], dataModelObjects[j]);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Unable to access protected field, change the access level: " + columnDetails.getColumnName());
                }
            }
        }
        return contentValuesArray;
    }

    public static <T> T inflate(Bundle bundle, TableDetails tableDetails) {
        Object dataModelObject;
        try {
            dataModelObject = tableDetails.createNewModelInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not create a new instance of data model object: " + tableDetails.getTableName());
        }
        for (TableDetails.ColumnDetails columnDetails : tableDetails.getColumns()) {
            ModelInflater.inflateColumn(bundle, dataModelObject, columnDetails);
        }
        return (T)dataModelObject;
    }

    public static <T> T inflate(Cursor cursor, TableDetails tableDetails) {
        Object dataModelObject;
        try {
            dataModelObject = tableDetails.createNewModelInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not create a new instance of data model object: " + tableDetails.getTableName());
        }
        int columnCount = cursor.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String columnName = cursor.getColumnName(i);
            TableDetails.ColumnDetails columnDetails = tableDetails.findColumn(columnName);
            ModelInflater.inflateColumn(cursor, dataModelObject, columnDetails, i);
        }
        return (T)dataModelObject;
    }

    private static <T> void inflateColumn(Cursor cursor, T dataModelObject, TableDetails.ColumnDetails columnDetails, int columnIndex) {
        if (!columnDetails.isRequired() && cursor.isNull(columnIndex)) {
            return;
        }
        try {
            columnDetails.setFieldValue(cursor, columnIndex, dataModelObject);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Not allowed to alter the value of the field, please change the access level: " + columnDetails.getColumnName());
        }
    }

    private static <T> void inflateColumn(Bundle bundle, T dataModelObject, TableDetails.ColumnDetails columnDetails) {
        if (!bundle.containsKey(columnDetails.getColumnName())) {
            return;
        }
        try {
            columnDetails.setFieldValue(bundle, columnDetails.getColumnName(), dataModelObject);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Not allowed to alter the value of the field, please change the access level: " + columnDetails.getColumnName());
        }
    }
}

