/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.generate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import za.co.cporm.model.annotation.Index;
import za.co.cporm.model.annotation.TableConstraint;
import za.co.cporm.model.generate.TableDetails;

public class TableGenerator {
    public static String generateTableDrop(TableDetails tableDetails, boolean prettyPrint) {
        StringBuilder tableQuery = new StringBuilder();
        TableGenerator.prettyPrint(0, prettyPrint, tableQuery);
        tableQuery.append("DROP TABLE IF EXISTS ");
        tableQuery.append(tableDetails.getTableName());
        tableQuery.append(";");
        return tableQuery.toString();
    }

    public static String generateTableCreate(TableDetails tableDetails, boolean prettyPrint) {
        StringBuilder tableQuery = new StringBuilder();
        TableGenerator.prettyPrint(0, prettyPrint, tableQuery);
        tableQuery.append("CREATE TABLE ");
        tableQuery.append(tableDetails.getTableName());
        TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
        tableQuery.append("(");
        TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
        Iterator<TableDetails.ColumnDetails> columnIterator = tableDetails.getColumns().iterator();
        while (columnIterator.hasNext()) {
            TableDetails.ColumnDetails columnDetails = columnIterator.next();
            TableGenerator.prettyPrint(2, prettyPrint, tableQuery);
            tableQuery.append((CharSequence)TableGenerator.createColumnDefinition(columnDetails));
            if (!columnIterator.hasNext()) continue;
            tableQuery.append(", ");
        }
        Iterator<TableConstraint> tableConstraintIterator = tableDetails.getConstraints().iterator();
        while (tableConstraintIterator.hasNext()) {
            TableConstraint tableConstraint = tableConstraintIterator.next();
            if (tableConstraint.constraintType() != TableConstraint.Type.PRIMARY_KEY) continue;
            TableGenerator.prettyPrint(3, prettyPrint, tableQuery);
            tableQuery.append((CharSequence)TableGenerator.createPrimaryKeyConstraint(tableConstraint));
            if (!tableConstraintIterator.hasNext()) continue;
            tableQuery.append(",");
        }
        TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
        tableQuery.append(");\n");
        TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
        for (TableConstraint tableConstraint : tableDetails.getConstraints()) {
            if (tableConstraint.constraintType() != TableConstraint.Type.UNIQUE) continue;
            TableGenerator.prettyPrint(3, prettyPrint, tableQuery);
            tableQuery.append((CharSequence)TableGenerator.createUniqueKeyConstraint(tableDetails.getTableName(), tableConstraint));
            tableQuery.append(";\n");
            TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
        }
        for (Index index : tableDetails.getIndices()) {
            TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
            tableQuery.append("CREATE INDEX ");
            tableQuery.append(index.indexName()).append("_").append(tableDetails.getTableName());
            tableQuery.append(" ON ");
            tableQuery.append(tableDetails.getTableName());
            tableQuery.append(" (");
            int length = index.indexColumns().length;
            for (int i = 0; i < length; ++i) {
                String column = index.indexColumns()[i];
                tableQuery.append(column);
                if (i + 1 >= length) continue;
                tableQuery.append(", ");
            }
            tableQuery.append(");\n");
            TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
        }
        return tableQuery.toString();
    }

    public static List<String> generateIndecesCreate(TableDetails tableDetails, boolean prettyPrint) {
        ArrayList<String> indeces = new ArrayList<String>();
        for (Index index : tableDetails.getIndices()) {
            StringBuilder tableQuery = new StringBuilder();
            TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
            tableQuery.append("CREATE INDEX ");
            tableQuery.append("IDX_").append(tableDetails.getTableName()).append("_").append(index.indexName());
            tableQuery.append(" ON ");
            tableQuery.append(tableDetails.getTableName());
            tableQuery.append(" (");
            int length = index.indexColumns().length;
            for (int i = 0; i < length; ++i) {
                String column = index.indexColumns()[i];
                tableQuery.append(column);
                if (i + 1 >= length) continue;
                tableQuery.append(", ");
            }
            tableQuery.append(");\n");
            TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
            indeces.add(tableQuery.toString());
        }
        return indeces;
    }

    private static void prettyPrint(int tabSpace, boolean prettyPrint, StringBuilder tableQuery) {
        if (prettyPrint) {
            tableQuery.append("\n");
            for (int i = 0; i < tabSpace; ++i) {
                tableQuery.append("\t");
            }
        }
    }

    private static StringBuilder createColumnDefinition(TableDetails.ColumnDetails columnDetails) {
        StringBuilder columnDefinition = new StringBuilder();
        columnDefinition.append(columnDetails.getColumnName());
        columnDefinition.append(" ");
        columnDefinition.append(columnDetails.getColumnTypeMapping().getSqlColumnTypeName());
        if (columnDetails.isPrimaryKey()) {
            columnDefinition.append(" PRIMARY KEY");
            if (columnDetails.isAutoIncrement()) {
                columnDefinition.append(" AUTOINCREMENT");
            }
        } else if (columnDetails.isUnique()) {
            columnDefinition.append(" UNIQUE");
        } else if (columnDetails.isRequired()) {
            columnDefinition.append(" NOT NULL");
        }
        return columnDefinition;
    }

    private static StringBuilder createPrimaryKeyConstraint(TableConstraint constraint) {
        StringBuilder constraintDef = new StringBuilder();
        constraintDef.append(" PRIMARY KEY ");
        Iterator<String> columnIterator = Arrays.asList(constraint.constraintColumns()).iterator();
        constraintDef.append("(");
        while (columnIterator.hasNext()) {
            String columnName = columnIterator.next();
            constraintDef.append(columnName);
            if (!columnIterator.hasNext()) continue;
            constraintDef.append(", ");
        }
        constraintDef.append(")");
        return constraintDef;
    }

    private static StringBuilder createUniqueKeyConstraint(String tableName, TableConstraint constraint) {
        StringBuilder constraintDef = new StringBuilder();
        constraintDef.append(" CREATE UNIQUE INDEX ");
        constraintDef.append(constraint.name());
        constraintDef.append(" ON ");
        constraintDef.append(tableName);
        Iterator<String> columnIterator = Arrays.asList(constraint.constraintColumns()).iterator();
        constraintDef.append("(");
        while (columnIterator.hasNext()) {
            String columnName = columnIterator.next();
            constraintDef.append(columnName);
            if (!columnIterator.hasNext()) continue;
            constraintDef.append(", ");
        }
        constraintDef.append(")");
        return constraintDef;
    }
}

