/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.generate;

import android.content.ContentValues;
import android.database.Cursor;
import android.os.Bundle;
import android.text.TextUtils;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import za.co.cporm.model.annotation.Index;
import za.co.cporm.model.annotation.TableConstraint;
import za.co.cporm.model.map.SqlColumnMapping;
import za.co.cporm.model.naming.ColumnNameConverter;
import za.co.cporm.model.util.DefaultColumnNameConverter;

public class TableDetails {
    public static ColumnNameConverter COLUMN_NAME_CONVERTER = new DefaultColumnNameConverter();
    private final String tableName;
    private final String authority;
    private final Class tableClass;
    private final boolean serializable;
    private final Constructor tableClassConstructor;
    private final List<ColumnDetails> columns = new LinkedList<ColumnDetails>();
    private final List<Index> indices = new LinkedList<Index>();
    private final List<TableConstraint> constraints = new LinkedList<TableConstraint>();
    private final List<Class<?>> changeListener = new LinkedList();
    private String primaryKeyClause;

    public TableDetails(String tableName, String authority, Class tableClass) {
        this.tableName = tableName;
        this.authority = authority;
        this.tableClass = tableClass;
        this.serializable = Serializable.class.isAssignableFrom(tableClass);
        try {
            this.tableClassConstructor = tableClass.getConstructor(new Class[0]);
            this.tableClassConstructor.setAccessible(true);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not create a new instance of data model object: " + tableName);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getAuthority() {
        return this.authority;
    }

    public Class getTableClass() {
        return this.tableClass;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public Object createNewModelInstance() throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.tableClassConstructor.newInstance(new Object[0]);
    }

    public ColumnDetails findPrimaryKeyColumn() {
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnDetails column = this.columns.get(i);
            if (!column.primaryKey) continue;
            return column;
        }
        return null;
    }

    public String[] getColumnNames() {
        String[] columnNames = new String[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnDetails columnDetails = this.columns.get(i);
            columnNames[i] = columnDetails.columnName;
        }
        return columnNames;
    }

    public List<ColumnDetails> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public ColumnDetails findColumn(String name) {
        for (int i = 0; i < this.columns.size(); ++i) {
            ColumnDetails column = this.columns.get(i);
            if (!column.columnName.equalsIgnoreCase(name)) continue;
            return column;
        }
        return null;
    }

    public String getPrimaryKeyClause() {
        return this.primaryKeyClause;
    }

    public void addColumn(ColumnDetails column) {
        this.columns.add(column);
        if (column.isPrimaryKey()) {
            this.primaryKeyClause = column.columnName + " = ?";
        }
        boolean hasPrimaryKey = false;
        for (ColumnDetails columnDetails : this.columns) {
            if (hasPrimaryKey && columnDetails.isPrimaryKey()) {
                throw new IllegalStateException("Table may only have one primary key constraint on column definition, is a table constraints to specify more than one");
            }
            hasPrimaryKey = hasPrimaryKey || columnDetails.isPrimaryKey();
        }
    }

    public List<Index> getIndices() {
        return Collections.unmodifiableList(this.indices);
    }

    public void addIndex(Index index) {
        this.indices.add(index);
    }

    public List<Class<?>> getChangeListeners() {
        return Collections.unmodifiableList(this.changeListener);
    }

    public void addChangeListener(Class<?> clazz) {
        this.changeListener.add(clazz);
    }

    public Collection<TableConstraint> getConstraints() {
        return this.constraints;
    }

    public void addConstraint(TableConstraint contConstraint) {
        this.constraints.add(contConstraint);
    }

    public static class ColumnDetails {
        private final String columnName;
        private final Field columnField;
        private final SqlColumnMapping columnTypeMapping;
        private final boolean primaryKey;
        private final boolean unique;
        private final boolean required;
        private final boolean autoIncrement;
        private final boolean notifyChanges;

        public ColumnDetails(String columnName, Field columnField, SqlColumnMapping columnTypeMapping, boolean primaryKey, boolean unique, boolean required, boolean autoIncrement, boolean notifyChanges) {
            this.columnName = columnName;
            this.columnField = columnField;
            this.columnTypeMapping = columnTypeMapping;
            this.primaryKey = primaryKey || autoIncrement;
            this.unique = unique;
            this.required = required;
            this.autoIncrement = autoIncrement;
            this.notifyChanges = notifyChanges;
            if (primaryKey && !required) {
                throw new IllegalStateException("Column must be not required if primary key is set");
            }
            if (TextUtils.isEmpty((CharSequence)columnName)) {
                throw new IllegalArgumentException("A valid column name needs to be provided");
            }
            columnField.setAccessible(true);
        }

        public String getColumnName() {
            return this.columnName;
        }

        public SqlColumnMapping getColumnTypeMapping() {
            return this.columnTypeMapping;
        }

        public Field getColumnField() {
            return this.columnField;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public boolean notifyChanges() {
            return this.notifyChanges;
        }

        public void setFieldValue(Cursor cursor, int columnIndex, Object dataModelObject) throws IllegalAccessException {
            this.columnField.set(dataModelObject, this.columnTypeMapping.getColumnValue(cursor, columnIndex));
        }

        public void setContentValue(ContentValues contentValues, Object dataModelObject) throws IllegalAccessException {
            Object value = this.columnField.get(dataModelObject);
            if (value == null) {
                contentValues.putNull(this.columnName);
            } else {
                this.columnTypeMapping.setColumnValue(contentValues, this.columnName, value);
            }
        }

        public <T> void setFieldValue(Bundle bundle, String columnName, T dataModelObject) throws IllegalAccessException {
            this.columnField.set(dataModelObject, this.columnTypeMapping.getColumnValue(bundle, columnName));
        }
    }
}

