/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import za.co.cporm.model.CPOrmConfiguration;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.generate.TableGenerator;
import za.co.cporm.model.generate.TableView;
import za.co.cporm.model.generate.TableViewGenerator;
import za.co.cporm.model.util.CPOrmCursorFactory;
import za.co.cporm.model.util.TableDetailsCache;
import za.co.cporm.util.CPOrmLog;

public class CPOrmDatabase
extends SQLiteOpenHelper {
    private final Context context;
    private final CPOrmConfiguration cPOrmConfiguration;
    private final TableDetailsCache tableDetailsCache;

    public CPOrmDatabase(Context context, CPOrmConfiguration cPOrmConfiguration) {
        super(context, cPOrmConfiguration.getDatabaseName(), (SQLiteDatabase.CursorFactory)new CPOrmCursorFactory(cPOrmConfiguration.isQueryLoggingEnabled()), cPOrmConfiguration.getDatabaseVersion());
        this.cPOrmConfiguration = cPOrmConfiguration;
        this.context = context;
        this.tableDetailsCache = new TableDetailsCache();
        this.tableDetailsCache.init(context, cPOrmConfiguration.getDataModelObjects());
    }

    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        for (Class<?> dataModelObject : this.cPOrmConfiguration.getDataModelObjects()) {
            String createStatement;
            if (TableView.class.isAssignableFrom(dataModelObject)) {
                createStatement = TableViewGenerator.createViewStatement(this.findTableDetails(dataModelObject), dataModelObject);
                if (this.cPOrmConfiguration.isQueryLoggingEnabled()) {
                    CPOrmLog.d("Creating View: " + createStatement);
                }
                sqLiteDatabase.execSQL(createStatement);
                continue;
            }
            createStatement = TableGenerator.generateTableCreate(this.findTableDetails(dataModelObject), this.cPOrmConfiguration.isQueryLoggingEnabled());
            if (this.cPOrmConfiguration.isQueryLoggingEnabled()) {
                CPOrmLog.d("Creating Table: " + createStatement);
            }
            sqLiteDatabase.execSQL(createStatement);
            for (String index : TableGenerator.generateIndecesCreate(this.findTableDetails(dataModelObject), this.cPOrmConfiguration.isQueryLoggingEnabled())) {
                if (this.cPOrmConfiguration.isQueryLoggingEnabled()) {
                    CPOrmLog.d("Creating Index: " + createStatement);
                }
                sqLiteDatabase.execSQL(index);
            }
        }
        try {
            String upgradeDir = this.cPOrmConfiguration.upgradeResourceDirectory();
            if (!TextUtils.isEmpty((CharSequence)upgradeDir)) {
                String initializeFileName = "0_init.sql";
                if (Arrays.binarySearch(this.context.getResources().getAssets().list(upgradeDir), initializeFileName) > -1) {
                    this.upgradeFromScript(sqLiteDatabase, -1, 0, initializeFileName);
                }
            }
        }
        catch (IOException e) {
            CPOrmLog.e("Failed to execute initialize script 0_init.sql", e);
        }
    }

    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
        String upgradeDir = this.cPOrmConfiguration.upgradeResourceDirectory();
        if (!TextUtils.isEmpty((CharSequence)upgradeDir)) {
            boolean upgraded = false;
            String[] scripts = null;
            try {
                scripts = this.context.getResources().getAssets().list(upgradeDir);
            }
            catch (IOException e) {
                CPOrmLog.e("Failed to load upgrade scripts", e);
            }
            if (scripts != null) {
                Arrays.sort(scripts, new UpgradeScriptComparator());
                for (String script : scripts) {
                    try {
                        upgraded = this.upgradeFromScript(sqLiteDatabase, oldVersion, newVersion, script);
                    }
                    catch (Exception e) {
                        CPOrmLog.e("Failed to execute upgrade script " + script, e);
                        CPOrmLog.e("Recreating database");
                        if (!this.cPOrmConfiguration.recreateDatabaseOnFailedUpgrade()) {
                            throw new RuntimeException("Failed to upgrade database", e);
                        }
                        upgraded = false;
                    }
                }
            }
            if (upgraded) {
                return;
            }
        }
        for (Class<?> dataModelObject : this.cPOrmConfiguration.getDataModelObjects()) {
            String statement;
            if (TableView.class.isAssignableFrom(dataModelObject)) {
                statement = TableViewGenerator.createDropViewStatement(this.findTableDetails(dataModelObject));
                if (this.cPOrmConfiguration.isQueryLoggingEnabled()) {
                    CPOrmLog.d("Dropping View: " + statement);
                }
                sqLiteDatabase.execSQL(statement);
                continue;
            }
            statement = TableGenerator.generateTableDrop(this.findTableDetails(dataModelObject), false);
            if (this.cPOrmConfiguration.isQueryLoggingEnabled()) {
                CPOrmLog.d("Dropping Table: " + statement);
            }
            sqLiteDatabase.execSQL(statement);
        }
        this.onCreate(sqLiteDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgradeFromScript(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion, String script) throws IOException {
        if (script.length() > 0) {
            Matcher matcher = Pattern.compile("^[0-9]+").matcher(script);
            if (matcher.find()) {
                String scriptFile = this.cPOrmConfiguration.upgradeResourceDirectory() + File.separator + script;
                Integer number = Integer.valueOf(matcher.group());
                if (number > oldVersion && number <= newVersion) {
                    try (BufferedReader scriptStream = new BufferedReader(new InputStreamReader(this.context.getResources().getAssets().open(scriptFile)));){
                        String line;
                        StringBuilder scriptContent = new StringBuilder();
                        while ((line = scriptStream.readLine()) != null) {
                            scriptContent.append(line);
                            scriptContent.append("\n");
                        }
                        if (!TextUtils.isEmpty((CharSequence)scriptContent)) {
                            if (scriptContent.indexOf(";") > -1) {
                                CPOrmLog.w("SQLite does not support multiple statements separated by ';', we will execute then separately for you");
                                StringTokenizer stringTokenizer = new StringTokenizer(scriptContent.toString(), ";");
                                while (stringTokenizer.hasMoreTokens()) {
                                    String content = stringTokenizer.nextToken().trim();
                                    if (TextUtils.isEmpty((CharSequence)content)) continue;
                                    CPOrmLog.d("Executing upgrade script " + scriptFile);
                                    if (this.cPOrmConfiguration.isQueryLoggingEnabled()) {
                                        CPOrmLog.d(content);
                                    }
                                    sqLiteDatabase.execSQL(content);
                                }
                            } else {
                                CPOrmLog.d("Executing upgrade script " + scriptFile);
                                if (this.cPOrmConfiguration.isQueryLoggingEnabled()) {
                                    CPOrmLog.d(scriptContent.toString());
                                }
                                sqLiteDatabase.execSQL(scriptContent.toString());
                            }
                        }
                    }
                    return number.equals(newVersion);
                }
            } else {
                CPOrmLog.e("Failed to parse upgrade script " + script + ", requires a starting integer indicating the version number");
            }
        }
        return false;
    }

    @TargetApi(value=16)
    public void onConfigure(SQLiteDatabase db) {
        super.onConfigure(db);
        if (!db.isReadOnly()) {
            db.enableWriteAheadLogging();
        }
    }

    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
        if (Build.VERSION.SDK_INT < 16 && Build.VERSION.SDK_INT > 11) {
            db.enableWriteAheadLogging();
        }
    }

    private TableDetails findTableDetails(Class<?> object) {
        return this.tableDetailsCache.findTableDetails(this.context, object);
    }

    public TableDetailsCache getTableDetailsCache() {
        return this.tableDetailsCache;
    }

    public CPOrmConfiguration getcPOrmConfiguration() {
        return this.cPOrmConfiguration;
    }

    private static class UpgradeScriptComparator
    implements Comparator<String> {
        private UpgradeScriptComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            Pattern pattern = Pattern.compile("^[0-9]+");
            Matcher match1 = pattern.matcher(o1);
            Matcher match2 = pattern.matcher(o2);
            if (!match1.find()) {
                return 1;
            }
            if (!match2.find()) {
                return -1;
            }
            Integer int1 = Integer.valueOf(match1.group());
            Integer int2 = Integer.valueOf(match2.group());
            return int1.compareTo(int2);
        }
    }
}

