/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.query;

import android.content.Context;
import android.text.TextUtils;
import java.util.Arrays;
import za.co.cporm.model.map.SqlColumnMappingFactory;
import za.co.cporm.model.query.DataFilterClause;
import za.co.cporm.model.query.QueryBuilder;

public class SQLSegment
implements DataFilterClause {
    private String sqlSegment;
    private Object[] args;

    private SQLSegment() {
    }

    public SQLSegment(String sqlSegment, Object ... args) {
        this.sqlSegment = sqlSegment;
        this.args = args;
    }

    @Override
    public QueryBuilder buildWhereClause(Context context, SqlColumnMappingFactory columnMappingFactory) {
        for (int i = 0; i < this.args.length; ++i) {
            Object argObject = this.args[i];
            this.args[i] = columnMappingFactory.findColumnMapping(argObject.getClass()).toSqlType(argObject);
        }
        return new QueryBuilder(this.sqlSegment, this.args);
    }

    @Override
    public QueryBuilder getWhereClause() {
        return new QueryBuilder(this.sqlSegment, new Object[0]);
    }

    public SQLSegment addClause(DataFilterClause clause, DataFilterClause.DataFilterConjunction conjunction) {
        throw new UnsupportedOperationException("Clauses cannot be added to a data filter criterion");
    }

    public SQLSegment cloneFrom() {
        SQLSegment clone = new SQLSegment();
        clone.sqlSegment = this.sqlSegment;
        if (this.args != null) {
            clone.args = Arrays.copyOf(this.args, this.args.length);
        }
        return clone;
    }

    @Override
    public boolean hasFilterValue() {
        return !TextUtils.isEmpty((CharSequence)this.sqlSegment);
    }
}

