/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.query;

import android.content.Context;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import za.co.cporm.model.map.SqlColumnMappingFactory;
import za.co.cporm.model.query.DataFilterClause;
import za.co.cporm.model.query.DataFilterCriterion;
import za.co.cporm.model.query.QueryBuilder;

public class DataFilterCriteria
implements DataFilterClause<DataFilterCriteria> {
    private final Map<DataFilterClause, DataFilterClause.DataFilterConjunction> filterClauses = new LinkedHashMap<DataFilterClause, DataFilterClause.DataFilterConjunction>();

    public DataFilterCriteria addClause(DataFilterClause clause) {
        this.addClause(clause, null);
        return this;
    }

    @Override
    public DataFilterCriteria addClause(DataFilterClause clause, DataFilterClause.DataFilterConjunction conjunction) {
        if (conjunction == null) {
            conjunction = DataFilterClause.DataFilterConjunction.AND;
        }
        if (clause != null) {
            this.filterClauses.put(clause, conjunction);
        }
        return this;
    }

    public DataFilterCriteria addCriterion(String column, DataFilterCriterion.DataFilterOperator operator, Object filterValue) {
        this.addClause(new DataFilterCriterion(column, operator, filterValue));
        return this;
    }

    @Override
    public QueryBuilder buildWhereClause(Context context, SqlColumnMappingFactory columnMappingFactory) {
        QueryBuilder builder = new QueryBuilder();
        if (!this.filterClauses.isEmpty()) {
            boolean isFirst = true;
            Iterator<DataFilterClause> clauseIterator = this.filterClauses.keySet().iterator();
            builder.append("(", new Object[0]);
            while (clauseIterator.hasNext()) {
                DataFilterClause clause = clauseIterator.next();
                if (!isFirst) {
                    builder.append(this.filterClauses.get(clause).name(), new Object[0]);
                    builder.append(" ", new Object[0]);
                } else {
                    isFirst = false;
                }
                builder.append(clause.buildWhereClause(context, columnMappingFactory));
                if (!clauseIterator.hasNext()) continue;
                builder.append(" ", new Object[0]);
            }
            builder.append(")", new Object[0]);
        }
        return builder;
    }

    @Override
    public QueryBuilder getWhereClause() {
        QueryBuilder builder = new QueryBuilder();
        if (this.hasFilterValue()) {
            DataFilterClause previousClause = null;
            Iterator<DataFilterClause> clauseIterator = this.filterClauses.keySet().iterator();
            builder.append("(", new Object[0]);
            while (clauseIterator.hasNext()) {
                DataFilterClause clause = clauseIterator.next();
                if (!clause.hasFilterValue()) continue;
                if (previousClause != null && previousClause.hasFilterValue()) {
                    builder.append(this.filterClauses.get(previousClause).toString(), new Object[0]);
                    builder.append(" ", new Object[0]);
                }
                builder.append(clause.getWhereClause());
                previousClause = clause;
                if (!clauseIterator.hasNext()) continue;
                builder.append(" ", new Object[0]);
            }
            builder.append(")", new Object[0]);
        }
        return builder;
    }

    public DataFilterCriteria cloneFrom() {
        DataFilterCriteria clone = new DataFilterCriteria();
        for (Map.Entry<DataFilterClause, DataFilterClause.DataFilterConjunction> entry : this.filterClauses.entrySet()) {
            clone.filterClauses.put(entry.getKey().cloneFrom(), entry.getValue());
        }
        return clone;
    }

    @Override
    public boolean hasFilterValue() {
        boolean hasFilterValue = false;
        for (DataFilterClause clause : this.filterClauses.keySet()) {
            hasFilterValue = hasFilterValue || clause.hasFilterValue();
        }
        return hasFilterValue;
    }

    public static class Builder<T extends DataFilterClause<T>>
    implements DataFilterClause<Builder<T>> {
        private final T originator;
        private final DataFilterClause.DataFilterConjunction conjunction;
        private final DataFilterCriteria criteria;

        protected Builder(T originator, DataFilterClause.DataFilterConjunction conjunction) {
            this.originator = originator;
            this.conjunction = conjunction;
            this.criteria = new DataFilterCriteria();
        }

        public DataFilterCriterion.Builder<Builder<T>> and() {
            return new DataFilterCriterion.Builder<Builder<T>>(this, DataFilterClause.DataFilterConjunction.AND);
        }

        public Builder<T> and(DataFilterClause dataFilterClause) {
            return this.addClause(dataFilterClause, DataFilterClause.DataFilterConjunction.AND);
        }

        public DataFilterCriterion.Builder<Builder<T>> or() {
            return new DataFilterCriterion.Builder<Builder<T>>(this, DataFilterClause.DataFilterConjunction.OR);
        }

        public Builder<T> or(DataFilterClause dataFilterClause) {
            return this.addClause(dataFilterClause, DataFilterClause.DataFilterConjunction.OR);
        }

        public Builder<Builder<T>> openBracketAnd() {
            return new Builder<Builder<T>>(this, DataFilterClause.DataFilterConjunction.AND);
        }

        public Builder<Builder<T>> openBracketOr() {
            return new Builder<Builder<T>>(this, DataFilterClause.DataFilterConjunction.OR);
        }

        public T closeBracket() {
            this.originator.addClause(this.criteria, this.conjunction);
            return this.originator;
        }

        @Override
        public QueryBuilder buildWhereClause(Context context, SqlColumnMappingFactory columnMappingFactory) {
            throw new UnsupportedOperationException("This cannot be called on a builder");
        }

        @Override
        public QueryBuilder getWhereClause() {
            throw new UnsupportedOperationException("This cannot be called on a builder");
        }

        @Override
        public Builder<T> addClause(DataFilterClause clause, DataFilterClause.DataFilterConjunction conjunction) {
            this.criteria.addClause(clause, conjunction);
            return this;
        }

        @Override
        public DataFilterClause<Builder<T>> cloneFrom() {
            throw new RuntimeException("Cannot clone a builder");
        }

        @Override
        public boolean hasFilterValue() {
            return this.criteria.hasFilterValue();
        }
    }
}

