/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.provider;

import android.annotation.TargetApi;
import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.CancellationSignal;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import za.co.cporm.model.CPOrmConfiguration;
import za.co.cporm.model.CPOrmDatabase;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.util.ManifestHelper;
import za.co.cporm.provider.util.UriMatcherHelper;
import za.co.cporm.util.CPOrmLog;

public class CPOrmContentProvider
extends ContentProvider {
    public static final String PARAMETER_OFFSET = "OFFSET";
    public static final String PARAMETER_LIMIT = "LIMIT";
    public static final String PARAMETER_SYNC = "IS_SYNC";
    protected CPOrmConfiguration cPOrmConfiguration;
    protected CPOrmDatabase database;
    protected UriMatcherHelper uriMatcherHelper;
    protected boolean debugEnabled;

    public boolean onCreate() {
        this.cPOrmConfiguration = ManifestHelper.getConfiguration(this.getContext());
        this.database = new CPOrmDatabase(this.getContext(), this.cPOrmConfiguration);
        this.debugEnabled = this.cPOrmConfiguration.isQueryLoggingEnabled();
        return true;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        super.attachInfo(context, info);
        this.uriMatcherHelper = new UriMatcherHelper(this.getContext(), info.authority);
        this.uriMatcherHelper.init(this.getContext(), this.database.getcPOrmConfiguration(), this.database.getTableDetailsCache());
    }

    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor cursor;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getReadableDatabase();
        String limit = this.constructLimit(uri);
        Boolean distinct = uri.getBooleanQueryParameter("DISTINCT", false);
        String groupBy = uri.getQueryParameter("GROUP_BY");
        String having = uri.getQueryParameter("HAVING");
        if (this.debugEnabled) {
            CPOrmLog.d("********* Query **********");
            CPOrmLog.d("Uri: " + uri);
            CPOrmLog.d("Projection: " + Arrays.toString(projection));
            CPOrmLog.d("Selection: " + selection);
            CPOrmLog.d("Args: " + Arrays.toString(selectionArgs));
            CPOrmLog.d("Sort: " + sortOrder);
            CPOrmLog.d("Limit: " + limit);
            CPOrmLog.d("Distinct: " + distinct);
            CPOrmLog.d("Group By: " + groupBy);
            CPOrmLog.d("Having: " + having);
        }
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            cursor = db.query(true, tableDetails.getTableName(), projection, tableDetails.getPrimaryKeyClause(), new String[]{itemId}, null, null, null, "1");
        } else {
            cursor = db.query(distinct.booleanValue(), tableDetails.getTableName(), projection, selection, selectionArgs, groupBy, having, sortOrder, limit);
        }
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    @TargetApi(value=16)
    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        Cursor cursor;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getReadableDatabase();
        String limit = this.constructLimit(uri);
        Boolean distinct = uri.getBooleanQueryParameter("DISTINCT", false);
        String groupBy = uri.getQueryParameter("GROUP_BY");
        String having = uri.getQueryParameter("HAVING");
        if (this.debugEnabled) {
            CPOrmLog.d("********* Query **********");
            CPOrmLog.d("Uri: " + uri);
            CPOrmLog.d("Projection: " + Arrays.toString(projection));
            CPOrmLog.d("Selection: " + selection);
            CPOrmLog.d("Args: " + Arrays.toString(selectionArgs));
            CPOrmLog.d("Sort: " + sortOrder);
            CPOrmLog.d("Limit: " + limit);
            CPOrmLog.d("Distinct: " + distinct);
            CPOrmLog.d("Group By: " + groupBy);
            CPOrmLog.d("Having: " + having);
        }
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            cursor = db.query(true, tableDetails.getTableName(), projection, tableDetails.getPrimaryKeyClause(), new String[]{itemId}, null, null, null, "1", cancellationSignal);
        } else {
            cursor = db.query(distinct.booleanValue(), tableDetails.getTableName(), projection, selection, selectionArgs, groupBy, having, sortOrder, limit, cancellationSignal);
        }
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    public String getType(@NonNull Uri uri) {
        return this.uriMatcherHelper.getType(uri);
    }

    public Uri insert(@NonNull Uri uri, ContentValues contentValues) {
        long insertId;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        if (this.debugEnabled) {
            CPOrmLog.d("********* Insert **********");
            CPOrmLog.d("Uri: " + uri);
            CPOrmLog.d("Content Values: " + contentValues);
        }
        if ((insertId = db.insertOrThrow(tableDetails.getTableName(), null, contentValues)) == -1L) {
            throw new IllegalArgumentException("Failed to insert row for into table " + tableDetails.getTableName() + " using values " + contentValues);
        }
        this.notifyChanges(uri, tableDetails);
        TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
        if (primaryKeyColumn.isAutoIncrement()) {
            return this.uriMatcherHelper.generateSingleItemUri(tableDetails, insertId);
        }
        String primaryKeyValue = contentValues.getAsString(primaryKeyColumn.getColumnName());
        return this.uriMatcherHelper.generateSingleItemUri(tableDetails, primaryKeyValue);
    }

    public int delete(@NonNull Uri uri, String where, String[] args) {
        int deleteCount;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        if (this.debugEnabled) {
            CPOrmLog.d("********* Delete **********");
            CPOrmLog.d("Uri: " + uri);
            CPOrmLog.d("Where: " + where);
            CPOrmLog.d("Args: " + Arrays.toString(args));
        }
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
            deleteCount = db.delete(tableDetails.getTableName(), primaryKeyColumn.getColumnName() + " = ?", new String[]{itemId});
        } else {
            deleteCount = db.delete(tableDetails.getTableName(), where, args);
        }
        if (deleteCount == 0) {
            return deleteCount;
        }
        this.notifyChanges(uri, tableDetails);
        return deleteCount;
    }

    public int update(@NonNull Uri uri, ContentValues contentValues, String where, String[] args) {
        int updateCount;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        if (this.debugEnabled) {
            CPOrmLog.d("********* Update **********");
            CPOrmLog.d("Uri: " + uri);
            CPOrmLog.d("Content Values: " + contentValues);
            CPOrmLog.d("Where: " + where);
            CPOrmLog.d("Args: " + Arrays.toString(args));
        }
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
            updateCount = db.update(tableDetails.getTableName(), contentValues, primaryKeyColumn.getColumnName() + " = ?", new String[]{itemId});
        } else {
            updateCount = db.update(tableDetails.getTableName(), contentValues, where, args);
        }
        if (updateCount > 0 && this.shouldChangesBeNotified(tableDetails, contentValues)) {
            this.notifyChanges(uri, tableDetails);
        }
        return updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(@NonNull Uri uri, @NonNull ContentValues[] values) {
        int length = values.length;
        if (length == 0) {
            return 0;
        }
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        if (this.debugEnabled) {
            CPOrmLog.d("********* Bulk Insert **********");
            CPOrmLog.d("Uri: " + uri);
        }
        int count = 0;
        try {
            db.beginTransactionNonExclusive();
            String tableName = tableDetails.getTableName();
            for (int i = 0; i < length; ++i) {
                db.insertOrThrow(tableName, null, values[i]);
                if (++count % 100 != 0) continue;
                db.yieldIfContendedSafely();
            }
            db.setTransactionSuccessful();
            this.notifyChanges(uri, tableDetails);
        }
        finally {
            db.endTransaction();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ContentProviderResult[] applyBatch(@NonNull ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        if (this.debugEnabled) {
            CPOrmLog.d("********* Apply Batch **********");
            CPOrmLog.d("Operations Count: " + operations.size());
        }
        SQLiteDatabase db = this.database.getWritableDatabase();
        try {
            db.beginTransactionNonExclusive();
            ContentProviderResult[] contentProviderResults = super.applyBatch(operations);
            db.setTransactionSuccessful();
            for (ContentProviderResult result : contentProviderResults) {
                if (result.uri == null) continue;
                TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(result.uri);
                this.notifyChanges(result.uri, tableDetails);
            }
            ContentProviderResult[] contentProviderResultArray = contentProviderResults;
            return contentProviderResultArray;
        }
        finally {
            db.endTransaction();
        }
    }

    private String constructLimit(Uri uri) {
        String offsetParam = uri.getQueryParameter(PARAMETER_OFFSET);
        String limitParam = uri.getQueryParameter(PARAMETER_LIMIT);
        Integer offset = null;
        Integer limit = null;
        if (!TextUtils.isEmpty((CharSequence)offsetParam) && TextUtils.isDigitsOnly((CharSequence)offsetParam)) {
            offset = Integer.valueOf(offsetParam);
        }
        if (!TextUtils.isEmpty((CharSequence)limitParam) && TextUtils.isDigitsOnly((CharSequence)limitParam)) {
            limit = Integer.valueOf(limitParam);
        }
        if (limit == null && offset == null) {
            return null;
        }
        StringBuilder limitStatement = new StringBuilder();
        if (limit != null && offset != null) {
            limitStatement.append(offset);
            limitStatement.append(",");
            limitStatement.append(limit);
        } else if (limit != null) {
            limitStatement.append(limit);
        } else {
            throw new IllegalArgumentException("A limit must also be provided when setting an offset");
        }
        return limitStatement.toString();
    }

    private boolean shouldChangesBeNotified(TableDetails tableDetails, ContentValues contentValues) {
        boolean notify = false;
        for (String columnName : contentValues.keySet()) {
            TableDetails.ColumnDetails column = tableDetails.findColumn(columnName);
            if (column == null) continue;
            notify = notify || column.notifyChanges();
        }
        return notify;
    }

    private void notifyChanges(Uri uri, TableDetails tableDetails) {
        Boolean sync = uri.getBooleanQueryParameter(PARAMETER_SYNC, true);
        this.getContext().getContentResolver().notifyChange(uri, null, sync.booleanValue());
        List<Class<?>> changeListeners = tableDetails.getChangeListeners();
        if (!changeListeners.isEmpty()) {
            int size = changeListeners.size();
            for (int i = 0; i < size; ++i) {
                Class<?> changeListener = changeListeners.get(i);
                TableDetails changeListenerDetails = this.database.getTableDetailsCache().findTableDetails(this.getContext(), changeListener);
                if (changeListenerDetails == null) continue;
                Uri changeUri = this.uriMatcherHelper.generateItemUri(changeListenerDetails);
                this.getContext().getContentResolver().notifyChange(changeUri, null, sync.booleanValue());
            }
        }
    }
}

