/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.util;

import android.content.ContentProviderClient;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.RemoteException;
import java.util.ArrayList;
import za.co.cporm.model.CPOrm;
import za.co.cporm.model.CPSyncHelper;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.util.CPOrmException;
import za.co.cporm.model.util.ModelInflater;

public class CPOrmBatchDispatcher<T>
extends ArrayList<T> {
    private final Context context;
    private final Class<? extends T> insertObject;
    private final int dispatchSize;
    private final Uri itemUri;
    private final TableDetails tableDetails;
    private ContentProviderClient provider;
    private boolean isSync;
    private boolean releaseProvider;

    public CPOrmBatchDispatcher(Context context, Class<? extends T> insertObject, int dispatchSize) {
        this.context = context;
        this.insertObject = insertObject;
        this.dispatchSize = dispatchSize;
        this.itemUri = CPOrm.getItemUri(context, insertObject);
        this.tableDetails = CPOrm.findTableDetails(context, insertObject);
        this.ensureCapacity(dispatchSize);
    }

    public CPOrmBatchDispatcher(Context context, ContentProviderClient provider, Class<? extends T> insertObject, boolean isSync, int dispatchSize) {
        this(context, insertObject, dispatchSize);
        this.provider = provider;
        this.isSync = isSync;
        this.releaseProvider = false;
    }

    @Override
    public boolean add(T object) {
        this.checkSizeAndDispatch();
        return super.add(object);
    }

    private void checkSizeAndDispatch() {
        if (this.size() >= this.dispatchSize) {
            this.dispatch();
        }
    }

    public void dispatch() {
        if (this.isEmpty()) {
            return;
        }
        if (this.provider == null) {
            this.provider = this.context.getContentResolver().acquireContentProviderClient(this.itemUri);
            this.releaseProvider = true;
        }
        try {
            if (this.isSync) {
                CPSyncHelper.insert(this.context, this.provider, this.toArray());
            } else {
                ContentValues[] values = ModelInflater.deflateAll(this.tableDetails, this.toArray());
                this.provider.bulkInsert(this.itemUri, values);
            }
            this.clear();
        }
        catch (RemoteException e) {
            this.release(false);
            throw new CPOrmException("Failed to insert objects", e);
        }
    }

    public void release(boolean dispatchRemaining) {
        if (dispatchRemaining) {
            this.dispatch();
        }
        this.clear();
        if (this.releaseProvider) {
            this.provider.release();
        }
    }
}

