/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model;

import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.OperationApplicationException;
import android.net.Uri;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;
import za.co.cporm.model.CPDefaultRecord;
import za.co.cporm.model.CPOrm;
import za.co.cporm.model.TransactionHelper;
import za.co.cporm.model.generate.TableDetails;

public class CPOrmTransaction {
    private List<CPDefaultRecord> records = new ArrayList<CPDefaultRecord>();

    public <T extends CPDefaultRecord> void addRecord(T record) {
        this.records.add(record);
    }

    public void commit() throws RemoteException, OperationApplicationException {
        this.commit(CPOrm.getApplicationContext());
    }

    public void commit(Context context) throws RemoteException, OperationApplicationException {
        if (this.records.isEmpty()) {
            return;
        }
        ContentResolver contentResolver = context.getContentResolver();
        ArrayList<ContentProviderOperation> operations = TransactionHelper.prepareTransaction(context, this.records);
        TableDetails tableDetails = CPOrm.findTableDetails(context, this.records.get(0).getClass());
        ContentProviderResult[] contentProviderResults = contentResolver.applyBatch(tableDetails.getAuthority(), operations);
        for (int i = 0; i < contentProviderResults.length; ++i) {
            long id;
            CPDefaultRecord cpDefaultRecord;
            ContentProviderResult contentProviderResult = contentProviderResults[i];
            if (contentProviderResult.uri == null || (cpDefaultRecord = this.records.get(i)).getId() != null || (id = ContentUris.parseId((Uri)contentProviderResult.uri)) == -1L) continue;
            cpDefaultRecord.setId(id);
        }
    }
}

