/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.query;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import za.co.cporm.model.CPOrm;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.map.SqlColumnMappingFactory;
import za.co.cporm.model.query.DataFilterClause;
import za.co.cporm.model.query.DataFilterCriteria;
import za.co.cporm.model.query.DataFilterCriterion;
import za.co.cporm.model.query.QueryBuilder;
import za.co.cporm.model.util.CPOrmCursor;
import za.co.cporm.model.util.ContentResolverValues;
import za.co.cporm.model.util.CursorIterator;
import za.co.cporm.model.util.ManifestHelper;
import za.co.cporm.provider.util.UriMatcherHelper;

public class Select<Model>
implements DataFilterClause<Select<Model>> {
    private final Class<Model> dataObjectClass;
    private DataFilterCriteria filterCriteria;
    private List<String> sortingOrderList;
    private List<String> includedColumns;
    private List<String> excludedColumns;
    private Integer offset;
    private Integer limit;
    private boolean distinct = false;
    private String groupBy;
    private String having;

    private Select(Class<Model> dataObjectClass) {
        this.dataObjectClass = dataObjectClass;
        this.sortingOrderList = new LinkedList<String>();
        this.filterCriteria = new DataFilterCriteria();
        this.includedColumns = new ArrayList<String>();
        this.excludedColumns = new ArrayList<String>();
    }

    public static <T> Select<T> from(Class<T> dataObjectClass) {
        return new Select<T>(dataObjectClass);
    }

    public Select<Model> distinct() {
        this.distinct = true;
        return this;
    }

    public Select<Model> where(DataFilterClause filterClause) {
        this.filterCriteria.addClause(filterClause);
        return this;
    }

    public Select<Model> where(DataFilterClause filterClause, DataFilterClause.DataFilterConjunction conjunction) {
        this.filterCriteria.addClause(filterClause, conjunction);
        return this;
    }

    public Select<Model> whereEquals(String column, Object value) {
        this.addClause(new DataFilterCriterion(column, DataFilterCriterion.DataFilterOperator.EQUAL, value), DataFilterClause.DataFilterConjunction.AND);
        return this;
    }

    public Select<Model> whereLike(String column, Object value) {
        this.addClause(new DataFilterCriterion(column, DataFilterCriterion.DataFilterOperator.LIKE, value), DataFilterClause.DataFilterConjunction.AND);
        return this;
    }

    public DataFilterCriterion.Builder<Select<Model>> and() {
        return new DataFilterCriterion.Builder<Select<Model>>(this, DataFilterClause.DataFilterConjunction.AND);
    }

    public Select<Model> and(DataFilterClause clause) {
        this.filterCriteria.addClause(clause, DataFilterClause.DataFilterConjunction.AND);
        return this;
    }

    public DataFilterCriterion.Builder<Select<Model>> or() {
        return new DataFilterCriterion.Builder<Select<Model>>(this, DataFilterClause.DataFilterConjunction.OR);
    }

    public Select<Model> or(DataFilterClause filterClause) {
        this.filterCriteria.addClause(filterClause, DataFilterClause.DataFilterConjunction.OR);
        return this;
    }

    public DataFilterCriteria.Builder<Select<Model>> openBracketAnd() {
        return new DataFilterCriteria.Builder<Select<Model>>(this, DataFilterClause.DataFilterConjunction.AND);
    }

    public DataFilterCriteria.Builder<Select<Model>> openBracketOr() {
        return new DataFilterCriteria.Builder<Select<Model>>(this, DataFilterClause.DataFilterConjunction.OR);
    }

    public Select<Model> sortDesc(String ... columns) {
        for (String column : columns) {
            this.sortingOrderList.add(column + " DESC");
        }
        return this;
    }

    public Select<Model> sortAsc(String ... columns) {
        for (String column : columns) {
            this.sortingOrderList.add(column + " ASC");
        }
        return this;
    }

    public Select<Model> offset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be larger than 0");
        }
        this.offset = offset;
        return this;
    }

    public Select<Model> limit(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException("Limit must be larger than 0");
        }
        this.limit = limit;
        return this;
    }

    public Select<Model> include(String ... columns) {
        Collections.addAll(this.includedColumns, columns);
        return this;
    }

    public Select<Model> exclude(String ... columns) {
        Collections.addAll(this.excludedColumns, columns);
        return this;
    }

    public Select<Model> groupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public Select<Model> having(String having) {
        this.having = having;
        return this;
    }

    public CPOrmCursor<Model> queryAsCursor() {
        return this.queryAsCursor(CPOrm.getApplicationContext());
    }

    public CPOrmCursor<Model> queryAsCursor(Context context) {
        ContentResolverValues contentResolverValues = this.asContentResolverValue(context);
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(contentResolverValues.getItemUri(), contentResolverValues.getProjection(), contentResolverValues.getWhere(), contentResolverValues.getWhereArgs(), contentResolverValues.getSortOrder());
        return new CPOrmCursor(contentResolverValues.getTableDetails(), cursor);
    }

    public CursorIterator<Model> queryAsIterator() {
        return this.queryAsIterator(CPOrm.getApplicationContext());
    }

    public CursorIterator<Model> queryAsIterator(Context context) {
        CPOrmCursor<Model> cursor = this.queryAsCursor(context);
        return new CursorIterator(cursor.getTableDetails(), (Cursor)cursor);
    }

    public List<Model> queryAsList() {
        return this.queryAsList(CPOrm.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Model> queryAsList(Context context) {
        try (CPOrmCursor<Model> cursor = this.queryAsCursor(context);){
            ArrayList<Model> resultList = new ArrayList<Model>(cursor.getCount());
            while (cursor.moveToNext()) {
                resultList.add(cursor.inflate());
            }
            ArrayList<Model> arrayList = resultList;
            return arrayList;
        }
    }

    public int queryAsCount() {
        return this.queryAsCount(CPOrm.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryAsCount(Context context) {
        ArrayList includedColumnsTemp = new ArrayList(this.includedColumns.size());
        ArrayList excludedColumnsTemp = new ArrayList(this.excludedColumns.size());
        Collections.copy(includedColumnsTemp, this.includedColumns);
        Collections.copy(excludedColumnsTemp, this.excludedColumns);
        this.includedColumns.clear();
        this.excludedColumns.clear();
        String columnName = CPOrm.findTableDetails(context, this.dataObjectClass).findPrimaryKeyColumn().getColumnName();
        this.includedColumns.add(columnName);
        CPOrmCursor<Model> cursor = this.queryAsCursor(context);
        try {
            int n = cursor.getCount();
            return n;
        }
        finally {
            cursor.close();
            this.includedColumns.clear();
            Collections.copy(this.includedColumns, this.includedColumns);
            Collections.copy(excludedColumnsTemp, this.excludedColumns);
        }
    }

    public ContentResolverValues asContentResolverValue() {
        return this.asContentResolverValue(CPOrm.getApplicationContext());
    }

    public ContentResolverValues asContentResolverValue(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Attempt to query with a null context");
        }
        TableDetails tableDetails = CPOrm.findTableDetails(context, this.dataObjectClass);
        QueryBuilder where = this.buildWhereClause(context, ManifestHelper.getMappingFactory(context));
        QueryBuilder sort = this.buildSort();
        Uri.Builder itemUri = UriMatcherHelper.generateItemUri(context, tableDetails);
        if (this.offset != null) {
            itemUri.appendQueryParameter("OFFSET", this.offset.toString());
        }
        if (this.limit != null) {
            itemUri.appendQueryParameter("LIMIT", this.limit.toString());
        }
        if (this.distinct) {
            itemUri.appendQueryParameter("DISTINCT", Boolean.TRUE.toString());
        }
        if (!TextUtils.isEmpty((CharSequence)this.groupBy)) {
            itemUri.appendQueryParameter("GROUP_BY", this.groupBy);
            if (!TextUtils.isEmpty((CharSequence)this.having)) {
                itemUri.appendQueryParameter("HAVING", this.having);
            }
        }
        return new ContentResolverValues(tableDetails, itemUri.build(), this.getProjection(tableDetails), where.getQueryString(), where.getQueryArgsAsArray(), sort.getQueryString());
    }

    public Model first() {
        return this.first(CPOrm.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model first(Context context) {
        Integer currentLimit = this.limit;
        this.limit(1);
        CPOrmCursor<Model> cursor = this.queryAsCursor(context);
        try {
            if (cursor.moveToFirst()) {
                Model inflate;
                Model Model = inflate = cursor.inflate();
                return Model;
            }
            Model Model = null;
            return Model;
        }
        finally {
            cursor.close();
            this.limit = currentLimit;
        }
    }

    public Model last() {
        return this.last(CPOrm.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model last(Context context) {
        ContentResolverValues values = this.asContentResolverValue(context);
        try (CPOrmCursor<Model> cursor = this.queryAsCursor(context);){
            if (cursor.moveToLast()) {
                Model Model = cursor.inflate();
                return Model;
            }
            Model Model = null;
            return Model;
        }
    }

    private String[] getProjection(TableDetails tableDetails) {
        if (!this.includedColumns.isEmpty()) {
            return this.includedColumns.toArray(new String[this.includedColumns.size()]);
        }
        if (!this.excludedColumns.isEmpty()) {
            ArrayList<String> columns = new ArrayList<String>();
            for (String column : tableDetails.getColumnNames()) {
                if (this.excludedColumns.contains(column)) continue;
                columns.add(column);
            }
            return columns.toArray(new String[columns.size()]);
        }
        return tableDetails.getColumnNames();
    }

    private QueryBuilder buildSort() {
        QueryBuilder builder = new QueryBuilder();
        Iterator<String> sortIterator = this.sortingOrderList.iterator();
        while (sortIterator.hasNext()) {
            builder.append(sortIterator.next(), new Object[0]);
            if (!sortIterator.hasNext()) continue;
            builder.append(", ", new Object[0]);
        }
        return builder;
    }

    protected QueryBuilder getSelectQuery(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Attempt to query with a null context");
        }
        TableDetails tableDetails = CPOrm.findTableDetails(context, this.dataObjectClass);
        QueryBuilder select = new QueryBuilder();
        QueryBuilder where = this.buildWhereClause(context, ManifestHelper.getMappingFactory(context));
        select.append("SELECT ", new Object[0]);
        if (this.distinct) {
            select.append("DISTINCT ", new Object[0]);
        }
        Iterator<String> columnIterator = Arrays.asList(this.getProjection(tableDetails)).iterator();
        while (columnIterator.hasNext()) {
            select.append(columnIterator.next(), new Object[0]);
            if (!columnIterator.hasNext()) continue;
            select.append(", ", new Object[0]);
        }
        select.append(" FROM ", new Object[0]);
        select.append(tableDetails.getTableName(), new Object[0]);
        if (this.hasFilterValue()) {
            select.append(" WHERE ", new Object[0]);
            select.append(where);
        }
        if (!TextUtils.isEmpty((CharSequence)this.groupBy)) {
            select.append(" GROUP BY ", new Object[0]);
            select.append(this.groupBy, new Object[0]);
            if (!TextUtils.isEmpty((CharSequence)this.having)) {
                select.append(" HAVING ", new Object[0]);
                select.append(this.having, new Object[0]);
            }
        }
        return select;
    }

    protected boolean isSingleColumnProjection() {
        return this.includedColumns.size() == 1;
    }

    @Override
    public QueryBuilder buildWhereClause(Context context, SqlColumnMappingFactory columnMappingFactory) {
        return this.filterCriteria.buildWhereClause(context, columnMappingFactory);
    }

    @Override
    public QueryBuilder getWhereClause() {
        return this.filterCriteria.getWhereClause();
    }

    @Override
    public Select<Model> addClause(DataFilterClause clause, DataFilterClause.DataFilterConjunction conjunction) {
        this.filterCriteria.addClause(clause, conjunction);
        return this;
    }

    @Override
    public boolean hasFilterValue() {
        return this.filterCriteria.hasFilterValue();
    }

    public String toString() {
        Context applicationContext = null;
        try {
            applicationContext = CPOrm.getApplicationContext();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (applicationContext == null) {
            return this.getWhereClause().toString();
        }
        return this.getSelectQuery(applicationContext).toString();
    }
}

