/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.map;

import java.util.ArrayList;
import java.util.List;
import za.co.cporm.model.map.SqlColumnMapping;
import za.co.cporm.model.map.types.BooleanType;
import za.co.cporm.model.map.types.CalendarType;
import za.co.cporm.model.map.types.DateType;
import za.co.cporm.model.map.types.DoubleType;
import za.co.cporm.model.map.types.FloatType;
import za.co.cporm.model.map.types.IntegerType;
import za.co.cporm.model.map.types.LongType;
import za.co.cporm.model.map.types.ShortType;
import za.co.cporm.model.map.types.StringType;
import za.co.cporm.model.map.types.UUIDType;

public class SqlColumnMappingFactory {
    private final List<SqlColumnMapping> columnMappings = new ArrayList<SqlColumnMapping>();

    public SqlColumnMappingFactory() {
        this.columnMappings.add(new BooleanType());
        this.columnMappings.add(new CalendarType());
        this.columnMappings.add(new DateType());
        this.columnMappings.add(new DoubleType());
        this.columnMappings.add(new FloatType());
        this.columnMappings.add(new IntegerType());
        this.columnMappings.add(new LongType());
        this.columnMappings.add(new ShortType());
        this.columnMappings.add(new StringType());
        this.columnMappings.add(new UUIDType());
    }

    public SqlColumnMapping findColumnMapping(Class<?> fieldType) {
        Class<?> fieldTypeWrapped = this.wrapPrimitives(fieldType);
        for (SqlColumnMapping columnMapping : this.columnMappings) {
            Class<?> columnType = columnMapping.getJavaType();
            if (!columnType.equals(fieldTypeWrapped) && !columnType.isAssignableFrom(fieldType)) continue;
            return columnMapping;
        }
        throw new IllegalArgumentException("No valid SQL mapping found for type " + fieldType);
    }

    private Class<?> wrapPrimitives(Class fieldType) {
        if (!fieldType.isPrimitive()) {
            return fieldType;
        }
        if (Long.TYPE.equals(fieldType)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(fieldType)) {
            return Integer.class;
        }
        if (Double.TYPE.equals(fieldType)) {
            return Double.class;
        }
        if (Float.TYPE.equals(fieldType)) {
            return Float.class;
        }
        if (Short.TYPE.equals(fieldType)) {
            return Short.class;
        }
        if (Boolean.TYPE.equals(fieldType)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(fieldType)) {
            return Byte.class;
        }
        if (Void.TYPE.equals(fieldType)) {
            return Void.class;
        }
        if (Character.TYPE.equals(fieldType)) {
            return Character.class;
        }
        throw new IllegalArgumentException("No primitive type registered for type " + fieldType);
    }
}

