/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.loader.support;

import android.content.Context;
import android.support.v4.content.CursorLoader;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.query.Select;
import za.co.cporm.model.util.CPOrmCursor;
import za.co.cporm.model.util.ContentResolverValues;

public class CPOrmLoader<Model>
extends CursorLoader {
    private TableDetails tableDetails;
    private int cacheSize = 0;

    public CPOrmLoader(Context context, Select<Model> select) {
        super(context);
        ContentResolverValues resolverValues = select.asContentResolverValue(context);
        this.setUri(resolverValues.getItemUri());
        this.setProjection(resolverValues.getProjection());
        this.setSelection(resolverValues.getWhere());
        this.setSelectionArgs(resolverValues.getWhereArgs());
        this.setSortOrder(resolverValues.getSortOrder());
        this.tableDetails = resolverValues.getTableDetails();
    }

    public CPOrmLoader(Context context, Select<Model> select, int cacheSize) {
        this(context, select);
        this.enableCursorCache(cacheSize);
    }

    public void enableCursorCache(int size) {
        this.cacheSize = size;
    }

    public CPOrmCursor<Model> loadInBackground() {
        CPOrmCursor cursor = new CPOrmCursor(this.tableDetails, super.loadInBackground());
        if (this.cacheSize == 0) {
            cursor.enableCache();
        } else if (this.cacheSize > 0) {
            cursor.enableCache(this.cacheSize);
        }
        int count = cursor.getCount();
        for (int i = 0; i < count && cursor.isCacheEnabled() && i < 100; ++i) {
            cursor.moveToPosition(i);
            Object inflate = cursor.inflate();
        }
        return cursor;
    }
}

