/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.util;

import android.content.ContentValues;
import android.database.Cursor;
import java.lang.reflect.Field;
import java.util.List;
import za.co.cporm.model.generate.TableDetails;

public class ModelInflater {
    public static Object deflateColumn(TableDetails tableDetails, TableDetails.ColumnDetails columnDetails, Object dataModelObject) {
        try {
            Object value = columnDetails.getColumnField().get(dataModelObject);
            if (value == null) {
                return null;
            }
            return columnDetails.getColumnTypeMapping().toSqlType(value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to access protected field, change the access level: " + columnDetails.getColumnName());
        }
    }

    public static ContentValues deflate(TableDetails tableDetails, Object dataModelObject) {
        List<TableDetails.ColumnDetails> columns = tableDetails.getColumns();
        ContentValues contentValues = new ContentValues(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            TableDetails.ColumnDetails columnDetails = columns.get(i);
            if (columnDetails.isAutoIncrement()) continue;
            try {
                String key = columnDetails.getColumnName();
                Object value = columnDetails.getColumnField().get(dataModelObject);
                if (value == null) {
                    contentValues.putNull(key);
                    continue;
                }
                columnDetails.getColumnTypeMapping().setColumnValue(contentValues, key, value);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to access protected field, change the access level: " + columnDetails.getColumnName());
            }
        }
        return contentValues;
    }

    public static <T> T inflate(Cursor cursor, TableDetails tableDetails) {
        Object dataModelObject;
        try {
            dataModelObject = tableDetails.getTableClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not create a new instance of data model object: " + tableDetails.getTableName());
        }
        for (int i = 0; i < cursor.getColumnCount(); ++i) {
            String columnName = cursor.getColumnName(i);
            TableDetails.ColumnDetails columnDetails = tableDetails.findColumn(columnName);
            ModelInflater.inflateColumn(cursor, dataModelObject, columnDetails, i);
        }
        return dataModelObject;
    }

    private static <T> void inflateColumn(Cursor cursor, T dataModelObject, TableDetails.ColumnDetails columnDetails, int columnIndex) {
        if (!columnDetails.isRequired() && cursor.isNull(columnIndex)) {
            return;
        }
        Field columnField = columnDetails.getColumnField();
        try {
            columnField.set(dataModelObject, columnDetails.getColumnTypeMapping().getColumnValue(cursor, columnIndex));
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Not allowed to alter the value of the field, please change the access level: " + columnDetails.getColumnName());
        }
    }
}

