/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model;

import android.content.ContentProviderClient;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.RemoteException;
import za.co.cporm.model.CPOrm;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.util.ModelInflater;
import za.co.cporm.provider.util.UriMatcherHelper;

public class CPSyncHelper {
    public static <T> void insert(Context context, ContentProviderClient provider, T ... dataModelObjects) throws RemoteException {
        if (dataModelObjects.length == 1) {
            T modelObject = dataModelObjects[0];
            TableDetails tableDetails = CPOrm.findTableDetails(context, modelObject.getClass());
            ContentValues contentValues = ModelInflater.deflate(tableDetails, modelObject);
            Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).appendQueryParameter("IS_SYNC", "false").build();
            provider.insert(insertUri, contentValues);
        } else {
            ContentValues[] insertObjects = new ContentValues[dataModelObjects.length];
            TableDetails tableDetails = null;
            for (int i = 0; i < dataModelObjects.length; ++i) {
                T modelObject = dataModelObjects[i];
                tableDetails = CPOrm.findTableDetails(context, modelObject.getClass());
                insertObjects[i] = ModelInflater.deflate(tableDetails, modelObject);
            }
            if (tableDetails != null) {
                Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).appendQueryParameter("IS_SYNC", "false").build();
                provider.bulkInsert(insertUri, insertObjects);
            }
        }
    }

    public static <T> T insertAndReturn(Context context, ContentProviderClient provider, T dataModelObject) throws RemoteException {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).appendQueryParameter("IS_SYNC", "false").build();
        Uri itemUri = provider.insert(insertUri, contentValues);
        return CPOrm.findSingleItem(context, itemUri, tableDetails);
    }

    public static <T> void update(Context context, ContentProviderClient provider, T dataModelObject) throws RemoteException {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).appendQueryParameter("IS_SYNC", "false").build();
        provider.update(itemUri, contentValues, null, null);
    }

    public static <T> void updateColumns(Context context, ContentProviderClient provider, T dataModelObject, String ... columns) throws RemoteException {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).appendQueryParameter("IS_SYNC", "false").build();
        for (String contentColumn : tableDetails.getColumnNames()) {
            boolean includeColumn = false;
            for (String column : columns) {
                if (!contentColumn.equals(column)) continue;
                includeColumn = true;
                break;
            }
            if (includeColumn) continue;
            contentValues.remove(contentColumn);
        }
        provider.update(itemUri, contentValues, null, null);
    }

    public static <T> void updateColumnsExcluding(Context context, ContentProviderClient provider, T dataModelObject, String ... columnsToExclude) throws RemoteException {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).appendQueryParameter("IS_SYNC", "false").build();
        for (String columnToExclude : columnsToExclude) {
            contentValues.remove(columnToExclude);
        }
        provider.update(itemUri, contentValues, null, null);
    }

    public static <T> void delete(Context context, ContentProviderClient provider, T dataModelObject) throws RemoteException {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).appendQueryParameter("IS_SYNC", "false").build();
        provider.delete(itemUri, null, null);
    }
}

