/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model;

import android.app.Application;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.query.Select;
import za.co.cporm.model.util.ContentResolverValues;
import za.co.cporm.model.util.CursorIterator;
import za.co.cporm.model.util.ManifestHelper;
import za.co.cporm.model.util.ModelInflater;
import za.co.cporm.model.util.TableDetailsCache;
import za.co.cporm.provider.util.UriMatcherHelper;

public class CPOrm {
    private static Context applicationContext;
    private static TableDetailsCache tableDetailsCache;

    public static void initialize(Application application) {
        applicationContext = application;
    }

    public static Context getApplicationContext() {
        if (applicationContext == null) {
            throw new IllegalArgumentException("You must call CPHelper.initialize() before using this method.");
        }
        return applicationContext;
    }

    public static <T> long countAll(Class<T> dataModel) {
        return CPOrm.countAll(CPOrm.getApplicationContext(), dataModel);
    }

    public static <T> long countAll(Context context, Class<T> dataModel) {
        return Select.from(dataModel).queryAsCount(context);
    }

    public static <T> Iterator<T> findAll(Class<T> dataModel) {
        return CPOrm.findAll(CPOrm.getApplicationContext(), dataModel);
    }

    public static <T> Iterator<T> findAll(Context context, Class<T> dataModel) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModel);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(itemUri, null, null, null, null);
        return new CursorIterator(tableDetails, cursor);
    }

    public static <T> T findByPrimaryKey(Class<T> dataModel, Object key) {
        return CPOrm.findByPrimaryKey(CPOrm.getApplicationContext(), dataModel, key);
    }

    public static <T> T findByPrimaryKey(Context context, Class<T> dataModel, Object key) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModel);
        TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
        Object columnValue = primaryKeyColumn.getColumnTypeMapping().toSqlType(key);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        return CPOrm.findSingleItem(context, itemUri, tableDetails);
    }

    public static <T> int insertAll(List<T> dataModelObjects) {
        return CPOrm.insertAll(CPOrm.getApplicationContext(), dataModelObjects);
    }

    public static <T> int insertAll(Context context, List<T> dataModelObjects) {
        if (dataModelObjects == null || dataModelObjects.isEmpty()) {
            return 0;
        }
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObjects.get(0).getClass());
        Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        ContentValues[] values = new ContentValues[dataModelObjects.size()];
        for (int i = 0; i < dataModelObjects.size(); ++i) {
            values[i] = ModelInflater.deflate(tableDetails, dataModelObjects.get(i));
        }
        ContentResolver contentResolver = context.getContentResolver();
        return contentResolver.bulkInsert(insertUri, values);
    }

    public static <T> void insert(T dataModelObject) {
        CPOrm.insert(CPOrm.getApplicationContext(), dataModelObject);
    }

    public static <T> void insert(Context context, T dataModelObject) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        ContentResolver contentResolver = context.getContentResolver();
        Uri itemUri = contentResolver.insert(insertUri, contentValues);
    }

    public static <T> T insertAndReturn(T dataModelObject) {
        return CPOrm.insertAndReturn(CPOrm.getApplicationContext(), dataModelObject);
    }

    public static <T> T insertAndReturn(Context context, T dataModelObject) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        ContentResolver contentResolver = context.getContentResolver();
        Uri itemUri = contentResolver.insert(insertUri, contentValues);
        return CPOrm.findSingleItem(context, itemUri, tableDetails);
    }

    public static <T> ContentProviderOperation prepareInsert(T dataModelObject) {
        return CPOrm.prepareInsert(CPOrm.getApplicationContext(), dataModelObject);
    }

    public static <T> ContentProviderOperation prepareInsert(Context context, T dataModelObject) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        return ContentProviderOperation.newInsert((Uri)insertUri).withExpectedCount(1).withValues(contentValues).build();
    }

    public static <T> void update(T dataModelObject) {
        CPOrm.update(CPOrm.getApplicationContext(), dataModelObject);
    }

    public static <T> void update(Context context, T dataModelObject) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.update(itemUri, contentValues, null, null);
    }

    public static <T> void updateColumns(T dataModelObject, String ... columns) {
        CPOrm.updateColumns(CPOrm.getApplicationContext(), dataModelObject, columns);
    }

    public static <T> void updateColumns(Context context, T dataModelObject, String ... columns) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        for (String contentColumn : tableDetails.getColumnNames()) {
            boolean includeColumn = false;
            for (String column : columns) {
                if (!contentColumn.equals(column)) continue;
                includeColumn = true;
                break;
            }
            if (includeColumn) continue;
            contentValues.remove(contentColumn);
        }
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.update(itemUri, contentValues, null, null);
    }

    public static <T> void updateColumnsExcluding(T dataModelObject, String ... columnsToExclude) {
        CPOrm.updateColumnsExcluding(CPOrm.getApplicationContext(), dataModelObject, columnsToExclude);
    }

    public static <T> void updateColumnsExcluding(Context context, T dataModelObject, String ... columnsToExclude) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        for (String columnToExclude : columnsToExclude) {
            contentValues.remove(columnToExclude);
        }
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.update(itemUri, contentValues, null, null);
    }

    public static <T> ContentProviderOperation prepareUpdate(T dataModelObject) {
        return CPOrm.prepareUpdate(CPOrm.getApplicationContext(), dataModelObject);
    }

    public static <T> ContentProviderOperation prepareUpdate(Context context, T dataModelObject) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        return ContentProviderOperation.newUpdate((Uri)itemUri).withExpectedCount(1).withValues(contentValues).build();
    }

    public static <T> void delete(T dataModelObject) {
        CPOrm.delete(CPOrm.getApplicationContext(), dataModelObject);
    }

    public static <T> void delete(Context context, T dataModelObject) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.delete(itemUri, null, null);
    }

    public static <T> void delete(Select<T> select) {
        CPOrm.delete(CPOrm.getApplicationContext(), select);
    }

    public static <T> void delete(Context context, Select<T> select) {
        ContentResolverValues contentResolverValues = select.asContentResolverValue(context);
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.delete(contentResolverValues.getItemUri(), contentResolverValues.getWhere(), contentResolverValues.getWhereArgs());
    }

    public static <T> ContentProviderOperation prepareDelete(T dataModelObject) {
        return CPOrm.prepareDelete(CPOrm.getApplicationContext(), dataModelObject);
    }

    public static <T> ContentProviderOperation prepareDelete(Context context, T dataModelObject) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        return ContentProviderOperation.newDelete((Uri)itemUri).withExpectedCount(1).build();
    }

    public static <T> ContentProviderOperation prepareDelete(Select<T> select) {
        return CPOrm.prepareDelete(CPOrm.getApplicationContext(), select);
    }

    public static <T> ContentProviderOperation prepareDelete(Context context, Select<T> select) {
        ContentResolverValues contentResolverValues = select.asContentResolverValue(context);
        return ContentProviderOperation.newDelete((Uri)contentResolverValues.getItemUri()).withSelection(contentResolverValues.getWhere(), contentResolverValues.getWhereArgs()).build();
    }

    public static <T> void deleteAll(Class<T> dataModel) {
        CPOrm.deleteAll(CPOrm.getApplicationContext(), dataModel);
    }

    public static <T> void deleteAll(Context context, Class<T> dataModel) {
        TableDetails tableDetails = CPOrm.findTableDetails(context, dataModel);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.delete(itemUri, null, null);
    }

    public static ContentProviderResult[] applyPreparedOperations(Collection<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        return CPOrm.applyPreparedOperations(CPOrm.getApplicationContext(), operations);
    }

    public static ContentProviderResult[] applyPreparedOperations(Context context, Collection<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        return context.getContentResolver().applyBatch(ManifestHelper.getAuthority(context), new ArrayList<ContentProviderOperation>(operations));
    }

    public static <T> Uri getItemUri(Class<T> dataModel) {
        TableDetails tableDetails = CPOrm.findTableDetails(CPOrm.getApplicationContext(), dataModel);
        return UriMatcherHelper.generateItemUri(CPOrm.getApplicationContext(), tableDetails).build();
    }

    protected static <T> T findSingleItem(Uri itemUri, TableDetails tableDetails) {
        return CPOrm.findSingleItem(CPOrm.getApplicationContext(), itemUri, tableDetails);
    }

    protected static <T> T findSingleItem(Context context, Uri itemUri, TableDetails tableDetails) {
        ContentResolver contentResolver = context.getContentResolver();
        try (Cursor cursor = null;){
            cursor = contentResolver.query(itemUri, tableDetails.getColumnNames(), null, null, null);
            if (cursor.moveToFirst()) {
                Object t = ModelInflater.inflate(cursor, tableDetails);
                return t;
            }
            throw new IllegalArgumentException("No row found with the key " + itemUri.getLastPathSegment());
        }
    }

    public static synchronized TableDetails findTableDetails(Context context, Class<?> item) {
        if (tableDetailsCache == null) {
            tableDetailsCache = new TableDetailsCache();
        }
        return tableDetailsCache.findTableDetails(context, item);
    }
}

