/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class QueryBuilder
implements Serializable {
    private final StringBuilder queryBuffer;
    private final List<Object> argsStore;

    public QueryBuilder() {
        this.queryBuffer = new StringBuilder();
        this.argsStore = new LinkedList<Object>();
    }

    public QueryBuilder(String init, Object ... args) {
        this.queryBuffer = new StringBuilder(init);
        this.argsStore = new LinkedList<Object>(Arrays.asList(args));
    }

    public void append(String query, Object ... args) {
        this.queryBuffer.append(query);
        for (Object arg : args) {
            this.argsStore.add(String.valueOf(arg));
        }
    }

    public void append(QueryBuilder queryBuilder) {
        this.queryBuffer.append(queryBuilder.getQueryString());
        this.argsStore.addAll(queryBuilder.getQueryArgs());
    }

    public String getQueryString() {
        StringBuilder queryString = new StringBuilder();
        queryString.append((CharSequence)this.queryBuffer);
        return queryString.toString();
    }

    private Collection<Object> getQueryArgs() {
        LinkedList<Object> queryArgs = new LinkedList<Object>();
        queryArgs.addAll(this.argsStore);
        return Collections.unmodifiableCollection(queryArgs);
    }

    public String[] getQueryArgsAsArray() {
        String[] args = new String[this.argsStore.size()];
        for (int i = 0; i < this.argsStore.size(); ++i) {
            args[i] = String.valueOf(this.argsStore.get(i));
        }
        return args;
    }

    public String toString() {
        return this.getQueryString();
    }
}

