/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.generate;

import android.text.TextUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import za.co.cporm.model.annotation.Index;
import za.co.cporm.model.annotation.TableConstraint;
import za.co.cporm.model.map.SqlColumnMapping;

public class TableDetails {
    private final String tableName;
    private final Class tableClass;
    private final Collection<ColumnDetails> columns = new LinkedList<ColumnDetails>();
    private final Collection<Index> indices = new LinkedList<Index>();
    private final Collection<TableConstraint> constraints = new LinkedList<TableConstraint>();
    private final Collection<Class<?>> changeListener = new LinkedList();

    public TableDetails(String tableName, Class tableClass) {
        this.tableName = tableName;
        this.tableClass = tableClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Class getTableClass() {
        return this.tableClass;
    }

    public ColumnDetails findPrimaryKeyColumn() {
        for (ColumnDetails column : this.columns) {
            if (!column.isPrimaryKey()) continue;
            return column;
        }
        return null;
    }

    public String[] getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>(this.columns.size());
        for (ColumnDetails column : this.columns) {
            columnNames.add(column.getColumnName());
        }
        return columnNames.toArray(new String[0]);
    }

    public Collection<ColumnDetails> getColumns() {
        return Collections.unmodifiableCollection(this.columns);
    }

    public ColumnDetails findColumn(String name) {
        for (ColumnDetails column : this.columns) {
            if (!column.getColumnName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public void addColumn(ColumnDetails column) {
        this.columns.add(column);
        boolean hasPrimaryKey = false;
        for (ColumnDetails columnDetails : this.columns) {
            if (hasPrimaryKey && columnDetails.isPrimaryKey()) {
                throw new IllegalStateException("Table may only have one primary key contraint on column definition, is a table constraints to specify more than one");
            }
            hasPrimaryKey = hasPrimaryKey || columnDetails.isPrimaryKey();
        }
    }

    public Collection<Index> getIndices() {
        return Collections.unmodifiableCollection(this.indices);
    }

    public void addIndex(Index index) {
        this.indices.add(index);
    }

    public Collection<Class<?>> getChangeListeners() {
        return Collections.unmodifiableCollection(this.changeListener);
    }

    public void addChangeListener(Class<?> clazz) {
        this.changeListener.add(clazz);
    }

    public Collection<TableConstraint> getConstraints() {
        return this.constraints;
    }

    public void addConstraint(TableConstraint contConstraint) {
        this.constraints.add(contConstraint);
    }

    public static class ColumnDetails {
        private final String columnName;
        private final Field columnField;
        private final SqlColumnMapping columnTypeMapping;
        private final boolean primaryKey;
        private final boolean unique;
        private final boolean required;
        private final boolean autoIncrement;
        private final boolean notifyChanges;

        public ColumnDetails(String columnName, Field columnField, SqlColumnMapping columnTypeMapping, boolean primaryKey, boolean unique, boolean required, boolean autoIncrement, boolean notifyChanges) {
            this.columnName = columnName;
            this.columnField = columnField;
            this.columnTypeMapping = columnTypeMapping;
            this.primaryKey = primaryKey || autoIncrement;
            this.unique = unique;
            this.required = required;
            this.autoIncrement = autoIncrement;
            this.notifyChanges = notifyChanges;
            if (primaryKey && !required) {
                throw new IllegalStateException("Column must be not required if primary key is set");
            }
            if (TextUtils.isEmpty((CharSequence)columnName)) {
                throw new IllegalArgumentException("A valid column name needs to be provided");
            }
        }

        public String getColumnName() {
            return this.columnName;
        }

        public SqlColumnMapping getColumnTypeMapping() {
            return this.columnTypeMapping;
        }

        public Field getColumnField() {
            this.columnField.setAccessible(true);
            return this.columnField;
        }

        public boolean isPrimaryKey() {
            return this.primaryKey;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public boolean notifyChanges() {
            return this.notifyChanges;
        }
    }
}

