/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model;

import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.query.Select;
import za.co.cporm.model.util.ContentResolverValues;
import za.co.cporm.model.util.CursorIterator;
import za.co.cporm.model.util.ManifestHelper;
import za.co.cporm.model.util.ModelInflater;
import za.co.cporm.model.util.TableDetailsCache;
import za.co.cporm.provider.util.UriMatcherHelper;

public class CPHelper {
    private static TableDetailsCache tableDetailsCache;

    public static <T> long countAll(Context context, Class<T> dataModel) {
        return Select.from(dataModel).queryAsCount(context);
    }

    public static <T> Iterator<T> findAll(Context context, Class<T> dataModel) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModel);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(itemUri, null, null, null, null);
        return new CursorIterator(tableDetails, cursor);
    }

    public static <T> T findByPrimaryKey(Context context, Class<T> dataModel, Object key) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModel);
        TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
        Object columnValue = primaryKeyColumn.getColumnTypeMapping().toSqlType(key);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        return CPHelper.findSingleItem(context, itemUri, tableDetails);
    }

    public static <T> int insertAll(Context context, List<T> dataModelObjects) {
        if (dataModelObjects == null || dataModelObjects.isEmpty()) {
            return 0;
        }
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObjects.get(0).getClass());
        Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        ContentValues[] values = new ContentValues[dataModelObjects.size()];
        for (int i = 0; i < dataModelObjects.size(); ++i) {
            values[i] = ModelInflater.deflate(tableDetails, dataModelObjects.get(i));
        }
        ContentResolver contentResolver = context.getContentResolver();
        return contentResolver.bulkInsert(insertUri, values);
    }

    public static <T> void insert(Context context, T dataModelObject) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        ContentResolver contentResolver = context.getContentResolver();
        Uri itemUri = contentResolver.insert(insertUri, contentValues);
    }

    public static <T> T insertAndReturn(Context context, T dataModelObject) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        ContentResolver contentResolver = context.getContentResolver();
        Uri itemUri = contentResolver.insert(insertUri, contentValues);
        return CPHelper.findSingleItem(context, itemUri, tableDetails);
    }

    public static <T> ContentProviderOperation prepareInsert(Context context, T dataModelObject) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        return ContentProviderOperation.newInsert((Uri)insertUri).withExpectedCount(1).withValues(contentValues).build();
    }

    public static <T> void update(Context context, T dataModelObject) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.update(itemUri, contentValues, null, null);
    }

    public static <T> ContentProviderOperation prepareUpdate(Context context, T dataModelObject) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        return ContentProviderOperation.newUpdate((Uri)itemUri).withExpectedCount(1).withValues(contentValues).build();
    }

    public static <T> void delete(Context context, T dataModelObject) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObject.getClass());
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.delete(itemUri, null, null);
    }

    public static <T> void delete(Context context, Select<T> select) {
        ContentResolverValues contentResolverValues = select.asContentResolverValue(context);
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.delete(contentResolverValues.getItemUri(), contentResolverValues.getWhere(), contentResolverValues.getWhereArgs());
    }

    public static <T> ContentProviderOperation prepareDelete(Context context, T dataModelObject) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).build();
        return ContentProviderOperation.newDelete((Uri)itemUri).withExpectedCount(1).build();
    }

    public static <T> ContentProviderOperation prepareDelete(Context context, Select<T> select) {
        ContentResolverValues contentResolverValues = select.asContentResolverValue(context);
        return ContentProviderOperation.newDelete((Uri)contentResolverValues.getItemUri()).withSelection(contentResolverValues.getWhere(), contentResolverValues.getWhereArgs()).build();
    }

    public static <T> void deleteAll(Context context, Class<T> dataModel) {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModel);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails).build();
        ContentResolver contentResolver = context.getContentResolver();
        contentResolver.delete(itemUri, null, null);
    }

    public static ContentProviderResult[] applyPreparedOperations(Context context, Collection<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        return context.getContentResolver().applyBatch(ManifestHelper.getAuthority(context), new ArrayList<ContentProviderOperation>(operations));
    }

    protected static <T> T findSingleItem(Context context, Uri itemUri, TableDetails tableDetails) {
        ContentResolver contentResolver = context.getContentResolver();
        try (Cursor cursor = null;){
            cursor = contentResolver.query(itemUri, null, null, null, null);
            if (cursor.moveToFirst()) {
                Object t = ModelInflater.inflate(cursor, tableDetails);
                return t;
            }
            throw new IllegalArgumentException("No row found with the key " + itemUri.getLastPathSegment());
        }
    }

    public static synchronized TableDetails findTableDetails(Context context, Class<?> item) {
        if (tableDetailsCache == null) {
            tableDetailsCache = new TableDetailsCache();
        }
        return tableDetailsCache.findTableDetails(context, item);
    }
}

