/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model;

import android.content.ContentProviderClient;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.RemoteException;
import za.co.cporm.model.CPHelper;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.util.ModelInflater;
import za.co.cporm.provider.util.UriMatcherHelper;

public class CPSyncHelper {
    public static <T> void insert(Context context, ContentProviderClient provider, T dataModelObject) throws RemoteException {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).appendQueryParameter("IS_SYNC", "false").build();
        Uri itemUri = provider.insert(insertUri, contentValues);
    }

    public static <T> T insertAndReturn(Context context, ContentProviderClient provider, T dataModelObject) throws RemoteException {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Uri insertUri = UriMatcherHelper.generateItemUri(context, tableDetails).appendQueryParameter("IS_SYNC", "false").build();
        Uri itemUri = provider.insert(insertUri, contentValues);
        return CPHelper.findSingleItem(context, itemUri, tableDetails);
    }

    public static <T> void update(Context context, ContentProviderClient provider, T dataModelObject) throws RemoteException {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).appendQueryParameter("IS_SYNC", "false").build();
        provider.update(itemUri, contentValues, null, null);
    }

    public static <T> void delete(Context context, ContentProviderClient provider, T dataModelObject) throws RemoteException {
        TableDetails tableDetails = CPHelper.findTableDetails(context, dataModelObject.getClass());
        ContentValues contentValues = ModelInflater.deflate(tableDetails, dataModelObject);
        Object columnValue = ModelInflater.deflateColumn(tableDetails, tableDetails.findPrimaryKeyColumn(), dataModelObject);
        Uri itemUri = UriMatcherHelper.generateItemUri(context, tableDetails, String.valueOf(columnValue)).appendQueryParameter("IS_SYNC", "false").build();
        provider.delete(itemUri, null, null);
    }
}

