/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.util;

import android.database.Cursor;
import android.database.CursorWrapper;
import android.support.v4.util.LruCache;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.util.ModelInflater;

public class CPOrmCursor<T>
extends CursorWrapper {
    private final TableDetails tableDetails;
    private LruCache<Integer, T> objectCache;

    public CPOrmCursor(TableDetails tableDetails, Cursor cursor) {
        super(cursor);
        this.tableDetails = tableDetails;
    }

    public CPOrmCursor(TableDetails tableDetails, Cursor cursor, int cacheSize) {
        this(tableDetails, cursor);
        this.enableCache(cacheSize);
    }

    public void enableCache(int size) {
        this.objectCache = new LruCache(size);
    }

    public void enableCache() {
        this.enableCache(this.getCount());
    }

    public T inflate() {
        return this.getObjectFromCacheOrInflate();
    }

    public TableDetails getTableDetails() {
        return this.tableDetails;
    }

    private T getObjectFromCacheOrInflate() {
        if (this.objectCache == null) {
            return ModelInflater.inflate((Cursor)this, this.tableDetails);
        }
        Object cachedObject = this.objectCache.get((Object)this.getPosition());
        if (cachedObject == null) {
            cachedObject = ModelInflater.inflate((Cursor)this, this.tableDetails);
            this.objectCache.put((Object)this.getPosition(), cachedObject);
        }
        return (T)cachedObject;
    }
}

