/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.util.Arrays;
import za.co.cporm.model.CPOrmDatabase;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.util.ManifestHelper;
import za.co.cporm.provider.util.UriMatcherHelper;

public class CPOrmContentProvider
extends ContentProvider {
    private static final String TAG = "CPOrmContentProvider";
    public static final String PARAMETER_OFFSET = "OFFSET";
    public static final String PARAMETER_LIMIT = "LIMIT";
    public static final String PARAMETER_SYNC = "SYNC";
    private CPOrmDatabase database;
    private UriMatcherHelper uriMatcherHelper;
    private boolean debugEnabled;

    public boolean onCreate() {
        this.debugEnabled = ManifestHelper.getDebugEnabled(this.getContext());
        this.database = new CPOrmDatabase(this.getContext(), this.debugEnabled);
        this.uriMatcherHelper = new UriMatcherHelper(this.getContext());
        this.uriMatcherHelper.init(this.getContext(), this.database.getModelFactory(), this.database.getTableDetailsCache());
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor cursor;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getReadableDatabase();
        String limit = this.constructLimit(uri);
        if (this.debugEnabled) {
            Log.d((String)TAG, (String)"********* Query **********");
            Log.d((String)TAG, (String)("Uri: " + uri));
            Log.d((String)TAG, (String)("Projection: " + Arrays.toString(projection)));
            Log.d((String)TAG, (String)("Selection: " + selection));
            Log.d((String)TAG, (String)("Args: " + Arrays.toString(selectionArgs)));
            Log.d((String)TAG, (String)("Sort: " + sortOrder));
            Log.d((String)TAG, (String)("Limit: " + limit));
        }
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
            cursor = db.query(tableDetails.getTableName(), tableDetails.getColumnNames(), primaryKeyColumn.getColumnName() + " = ?", new String[]{itemId}, null, null, null);
        } else {
            cursor = db.query(tableDetails.getTableName(), projection, selection, selectionArgs, null, null, sortOrder, limit);
        }
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    public String getType(Uri uri) {
        return this.uriMatcherHelper.getType(uri);
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        TableDetails.ColumnDetails primaryKeyColumn;
        long insertId;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        Boolean sync = uri.getBooleanQueryParameter(PARAMETER_SYNC, true);
        if (this.debugEnabled) {
            Log.d((String)TAG, (String)"********* Insert **********");
            Log.d((String)TAG, (String)("Uri: " + uri));
            Log.d((String)TAG, (String)("Content Values: " + contentValues));
        }
        if ((insertId = db.insertOrThrow(tableDetails.getTableName(), null, contentValues)) == -1L) {
            throw new IllegalArgumentException("Failed to insert row for uri " + uri + " using values " + contentValues);
        }
        this.getContext().getContentResolver().notifyChange(uri, null, sync.booleanValue());
        if (!tableDetails.getChangeListeners().isEmpty()) {
            for (Class<?> changeListener : tableDetails.getChangeListeners()) {
                TableDetails changeListenerDetails = this.database.getTableDetailsCache().findTableDetails(this.getContext(), changeListener);
                if (changeListenerDetails == null) continue;
                Uri changeUri = this.uriMatcherHelper.generateItemUri(changeListenerDetails);
                this.getContext().getContentResolver().notifyChange(changeUri, null, sync.booleanValue());
            }
        }
        if ((primaryKeyColumn = tableDetails.findPrimaryKeyColumn()).isAutoIncrement()) {
            return this.uriMatcherHelper.generateSingleItemUri(tableDetails, insertId);
        }
        String primaryKeyValue = contentValues.getAsString(primaryKeyColumn.getColumnName());
        return this.uriMatcherHelper.generateSingleItemUri(tableDetails, primaryKeyValue);
    }

    public int delete(Uri uri, String where, String[] args) {
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        Boolean sync = uri.getBooleanQueryParameter(PARAMETER_SYNC, true);
        if (this.debugEnabled) {
            Log.d((String)TAG, (String)"********* Delete **********");
            Log.d((String)TAG, (String)("Uri: " + uri));
            Log.d((String)TAG, (String)("Where: " + where));
            Log.d((String)TAG, (String)("Args: " + Arrays.toString(args)));
        }
        int deleteCount = 0;
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
            deleteCount = db.delete(tableDetails.getTableName(), primaryKeyColumn.getColumnName() + " = ?", new String[]{itemId});
        } else {
            deleteCount = db.delete(tableDetails.getTableName(), where, args);
        }
        if (deleteCount > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null, sync.booleanValue());
            if (!tableDetails.getChangeListeners().isEmpty()) {
                for (Class<?> changeListener : tableDetails.getChangeListeners()) {
                    TableDetails changeListenerDetails = this.database.getTableDetailsCache().findTableDetails(this.getContext(), changeListener);
                    if (changeListenerDetails == null) continue;
                    Uri changeUri = this.uriMatcherHelper.generateItemUri(changeListenerDetails);
                    this.getContext().getContentResolver().notifyChange(changeUri, null, sync.booleanValue());
                }
            }
        }
        return deleteCount;
    }

    public int update(Uri uri, ContentValues contentValues, String where, String[] args) {
        String itemId;
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        Boolean sync = uri.getBooleanQueryParameter(PARAMETER_SYNC, true);
        if (this.debugEnabled) {
            Log.d((String)TAG, (String)"********* Update **********");
            Log.d((String)TAG, (String)("Uri: " + uri));
            Log.d((String)TAG, (String)("Content Values: " + contentValues));
            Log.d((String)TAG, (String)("Where: " + where));
            Log.d((String)TAG, (String)("Args: " + Arrays.toString(args)));
        }
        int updateCount = 0;
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            itemId = uri.getLastPathSegment();
            TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
            updateCount = db.update(tableDetails.getTableName(), contentValues, primaryKeyColumn.getColumnName() + " = ?", new String[]{itemId});
        } else {
            updateCount = db.update(tableDetails.getTableName(), contentValues, where, args);
        }
        if (updateCount > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null, sync.booleanValue());
            if (!tableDetails.getChangeListeners().isEmpty()) {
                itemId = uri.getLastPathSegment();
                for (Class<?> changeListener : tableDetails.getChangeListeners()) {
                    TableDetails changeListenerDetails = this.database.getTableDetailsCache().findTableDetails(this.getContext(), changeListener);
                    if (changeListenerDetails == null) continue;
                    Uri changeUri = TextUtils.isEmpty((CharSequence)itemId) ? this.uriMatcherHelper.generateItemUri(changeListenerDetails) : this.uriMatcherHelper.generateSingleItemUri(changeListenerDetails, itemId);
                    this.getContext().getContentResolver().notifyChange(changeUri, null, sync.booleanValue());
                }
            }
        }
        return updateCount;
    }

    private String constructLimit(Uri uri) {
        String offsetParam = uri.getQueryParameter(PARAMETER_OFFSET);
        String limitParam = uri.getQueryParameter(PARAMETER_LIMIT);
        Integer offset = null;
        Integer limit = null;
        if (!TextUtils.isEmpty((CharSequence)offsetParam) && TextUtils.isDigitsOnly((CharSequence)offsetParam)) {
            offset = Integer.valueOf(offsetParam);
        }
        if (!TextUtils.isEmpty((CharSequence)limitParam) && TextUtils.isDigitsOnly((CharSequence)limitParam)) {
            limit = Integer.valueOf(limitParam);
        }
        if (limit == null && offset == null) {
            return null;
        }
        StringBuilder limitStatement = new StringBuilder();
        if (limit != null && offset != null) {
            limitStatement.append(offset);
            limitStatement.append(",");
            limitStatement.append(limit);
        } else if (limit != null) {
            limitStatement.append(limit);
        } else {
            throw new IllegalArgumentException("A limit must also be provided when setting an offset");
        }
        return limitStatement.toString();
    }
}

