/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.provider.util;

import android.content.ContentUris;
import android.content.Context;
import android.content.UriMatcher;
import android.net.Uri;
import java.util.LinkedHashMap;
import java.util.Map;
import za.co.cporm.model.ModelFactory;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.util.ManifestHelper;
import za.co.cporm.model.util.TableDetailsCache;

public class UriMatcherHelper {
    public static int MATCHER_CODE_INTERVALS = 100;
    public static int MATCHER_ALL = 1;
    public static int MATCHER_SINGLE = 2;
    private final Map<Integer, TableDetails> matcherCodes = new LinkedHashMap<Integer, TableDetails>();
    private final String authority;
    private UriMatcher uriMatcher;

    public UriMatcherHelper(Context context) {
        this.authority = ManifestHelper.getAuthority(context);
    }

    public void init(Context context, ModelFactory modelFactory, TableDetailsCache detailsCache) {
        this.uriMatcher = new UriMatcher(-1);
        int matcherInterval = MATCHER_CODE_INTERVALS;
        for (Class<?> dataModelObject : modelFactory.getDataModelObjects()) {
            TableDetails tableDetails = detailsCache.findTableDetails(context, dataModelObject);
            this.matcherCodes.put(matcherInterval, tableDetails);
            this.uriMatcher.addURI(this.authority, tableDetails.getTableName(), matcherInterval + MATCHER_ALL);
            this.uriMatcher.addURI(this.authority, tableDetails.getTableName() + "/*", matcherInterval + MATCHER_SINGLE);
            matcherInterval += MATCHER_CODE_INTERVALS;
        }
    }

    public TableDetails getTableDetails(Uri uri) {
        int matchCode = this.uriMatcher.match(uri);
        try {
            return this.findTableDetails(matchCode);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not find table information for Uri, make sure the model factory knows of this table: " + uri, ex);
        }
    }

    public String getType(Uri uri) {
        int matchCode = this.uriMatcher.match(uri);
        TableDetails tableDetails = this.findTableDetails(matchCode);
        StringBuilder mimeType = new StringBuilder();
        mimeType.append("android.cursor.");
        if (this.isSingleItemRequested(matchCode)) {
            mimeType.append(".item");
        } else {
            mimeType.append(".dir");
        }
        mimeType.append("/");
        mimeType.append("vnd.");
        mimeType.append(this.authority);
        if (mimeType.charAt(mimeType.length() - 1) != '.') {
            mimeType.append(".");
        }
        mimeType.append(tableDetails.getTableName());
        return mimeType.toString();
    }

    public boolean isSingleItemRequested(int code) {
        return this.matcherCodes.containsKey(code - MATCHER_SINGLE);
    }

    public boolean isSingleItemRequested(Uri uri) {
        return this.isSingleItemRequested(this.uriMatcher.match(uri));
    }

    public Uri generateItemUri(TableDetails tableDetails) {
        return new Uri.Builder().scheme("content").authority(this.authority).appendEncodedPath(tableDetails.getTableName()).build();
    }

    public Uri generateSingleItemUri(TableDetails tableDetails, String itemId) {
        return new Uri.Builder().scheme("content").authority(this.authority).appendEncodedPath(tableDetails.getTableName() + "/").appendEncodedPath(itemId).build();
    }

    public Uri generateSingleItemUri(TableDetails tableDetails, long itemId) {
        return ContentUris.withAppendedId((Uri)this.generateItemUri(tableDetails), (long)itemId);
    }

    private TableDetails findTableDetails(int code) {
        if (this.matcherCodes.containsKey(code)) {
            return this.matcherCodes.get(code);
        }
        if (this.matcherCodes.containsKey(code - MATCHER_ALL)) {
            return this.matcherCodes.get(code - MATCHER_ALL);
        }
        if (this.matcherCodes.containsKey(code - MATCHER_SINGLE)) {
            return this.matcherCodes.get(code - MATCHER_SINGLE);
        }
        throw new IllegalArgumentException("No URI match found for code: " + code);
    }

    public static Uri.Builder generateItemUri(Context context, TableDetails tableDetails) {
        String authority = ManifestHelper.getAuthority(context);
        return new Uri.Builder().scheme("content").authority(authority).appendEncodedPath(tableDetails.getTableName());
    }

    public static Uri.Builder generateItemUri(Context context, TableDetails tableDetails, String itemId) {
        String authority = ManifestHelper.getAuthority(context);
        return new Uri.Builder().scheme("content").authority(authority).appendEncodedPath(tableDetails.getTableName()).appendEncodedPath(itemId);
    }
}

