/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.text.TextUtils;
import za.co.cporm.model.CPOrmDatabase;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.provider.util.UriMatcherHelper;

public class CPOrmContentProvider
extends ContentProvider {
    public static final String PARAMETER_OFFSET = "OFFSET";
    public static final String PARAMETER_LIMIT = "LIMIT";
    private CPOrmDatabase database;
    private UriMatcherHelper uriMatcherHelper;

    public boolean onCreate() {
        this.database = new CPOrmDatabase(this.getContext());
        this.uriMatcherHelper = new UriMatcherHelper(this.getContext());
        this.uriMatcherHelper.init(this.getContext(), this.database.getModelFactory(), this.database.getTableDetailsCache());
        return true;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getReadableDatabase();
        String limit = this.constructLimit(uri);
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
            return db.query(tableDetails.getTableName(), tableDetails.getColumnNames(), primaryKeyColumn.getColumnName() + " = ?", new String[]{itemId}, null, null, null);
        }
        return db.query(tableDetails.getTableName(), projection, selection, selectionArgs, null, null, sortOrder, limit);
    }

    public String getType(Uri uri) {
        return this.uriMatcherHelper.getType(uri);
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        long insertId = db.insert(tableDetails.getTableName(), null, contentValues);
        TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
        if (primaryKeyColumn.isAutoIncrement()) {
            return this.uriMatcherHelper.generateSingleItemUri(tableDetails, String.valueOf(insertId));
        }
        String primaryKeyValue = contentValues.getAsString(primaryKeyColumn.getColumnName());
        return this.uriMatcherHelper.generateSingleItemUri(tableDetails, primaryKeyValue);
    }

    public int delete(Uri uri, String where, String[] args) {
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
            return db.delete(tableDetails.getTableName(), primaryKeyColumn.getColumnName() + " = ?", new String[]{itemId});
        }
        return db.delete(tableDetails.getTableName(), where, args);
    }

    public int update(Uri uri, ContentValues contentValues, String where, String[] args) {
        TableDetails tableDetails = this.uriMatcherHelper.getTableDetails(uri);
        SQLiteDatabase db = this.database.getWritableDatabase();
        if (this.uriMatcherHelper.isSingleItemRequested(uri)) {
            String itemId = uri.getLastPathSegment();
            TableDetails.ColumnDetails primaryKeyColumn = tableDetails.findPrimaryKeyColumn();
            return db.update(tableDetails.getTableName(), contentValues, primaryKeyColumn.getColumnName() + " = ?", new String[]{itemId});
        }
        return db.update(tableDetails.getTableName(), contentValues, where, args);
    }

    private String constructLimit(Uri uri) {
        String offsetParam = uri.getQueryParameter(PARAMETER_OFFSET);
        String limitParam = uri.getQueryParameter(PARAMETER_LIMIT);
        Integer offset = null;
        Integer limit = null;
        if (!TextUtils.isEmpty((CharSequence)offsetParam) && TextUtils.isDigitsOnly((CharSequence)offsetParam)) {
            offset = Integer.valueOf(offsetParam);
        }
        if (!TextUtils.isEmpty((CharSequence)limitParam) && TextUtils.isDigitsOnly((CharSequence)limitParam)) {
            limit = Integer.valueOf(limitParam);
        }
        if (limit == null && offset == null) {
            return null;
        }
        StringBuilder limitStatement = new StringBuilder();
        if (limit != null && offset != null) {
            limitStatement.append(" LIMIT ");
            limitStatement.append(offset);
            limitStatement.append(", ");
            limitStatement.append(limit);
        } else if (limit != null) {
            limitStatement.append(" LIMIT ");
            limitStatement.append(limit);
        } else {
            limitStatement.append(" OFFSET ");
            limitStatement.append(offset);
        }
        return limitStatement.toString();
    }
}

