/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model.generate;

import java.util.Arrays;
import java.util.Iterator;
import za.co.cporm.model.annotation.TableConstraint;
import za.co.cporm.model.generate.TableDetails;

public class TableGenerator {
    public static String generateTableDrop(TableDetails tableDetails, boolean prettyPrint) {
        StringBuilder tableQuery = new StringBuilder();
        TableGenerator.prettyPrint(0, prettyPrint, tableQuery);
        tableQuery.append("DROP TABLE IF EXISTS ");
        tableQuery.append(tableDetails.getTableName());
        return tableQuery.toString();
    }

    public static String generateTableCreate(TableDetails tableDetails, boolean prettyPrint) {
        StringBuilder tableQuery = new StringBuilder();
        TableGenerator.prettyPrint(0, prettyPrint, tableQuery);
        tableQuery.append("CREATE TABLE ");
        tableQuery.append(tableDetails.getTableName());
        TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
        tableQuery.append("(");
        TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
        Iterator<TableDetails.ColumnDetails> columnIterator = tableDetails.getColumns().iterator();
        while (columnIterator.hasNext()) {
            TableDetails.ColumnDetails columnDetails = columnIterator.next();
            TableGenerator.prettyPrint(2, prettyPrint, tableQuery);
            tableQuery.append((CharSequence)TableGenerator.createColumnDefinition(columnDetails));
            if (!columnIterator.hasNext()) continue;
            tableQuery.append(", ");
        }
        Iterator<TableConstraint> tableConstraintIterator = tableDetails.getConstraints().iterator();
        while (tableConstraintIterator.hasNext()) {
            TableConstraint tableConstraint = tableConstraintIterator.next();
            TableGenerator.prettyPrint(3, prettyPrint, tableQuery);
            tableQuery.append((CharSequence)TableGenerator.createTableConstraint(tableConstraint));
            if (!tableConstraintIterator.hasNext()) continue;
            tableQuery.append(",");
        }
        TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
        tableQuery.append(")");
        TableGenerator.prettyPrint(1, prettyPrint, tableQuery);
        return tableQuery.toString();
    }

    private static void prettyPrint(int tabSpace, boolean prettyPrint, StringBuilder tableQuery) {
        if (prettyPrint) {
            tableQuery.append("\n");
            for (int i = 0; i < tabSpace; ++i) {
                tableQuery.append("\t");
            }
        }
    }

    private static StringBuilder createColumnDefinition(TableDetails.ColumnDetails columnDetails) {
        StringBuilder columnDefinition = new StringBuilder();
        columnDefinition.append(columnDetails.getColumnName());
        columnDefinition.append(" ");
        columnDefinition.append(columnDetails.getColumnTypeMapping().getSqlColumnTypeName());
        if (columnDetails.isPrimaryKey()) {
            columnDefinition.append(" PRIMARY KEY");
            if (columnDetails.isAutoIncrement()) {
                columnDefinition.append(" AUTOINCREMENT");
            }
        } else if (columnDetails.isUnique()) {
            columnDefinition.append(" UNIQUE");
        } else if (columnDetails.isRequired()) {
            columnDefinition.append(" NOT NULL");
        }
        return columnDefinition;
    }

    private static StringBuilder createTableConstraint(TableConstraint constraint) {
        StringBuilder constraintDef = new StringBuilder();
        constraintDef.append("CONSTRAINT ");
        constraintDef.append(constraint.name());
        switch (constraint.constraintType()) {
            case PRIMARY_KEY: {
                constraintDef.append(" PRIMARY KEY ");
                break;
            }
            case UNIQUE: {
                constraintDef.append(" UNIQUE ");
                break;
            }
            default: {
                throw new IllegalArgumentException("Constraint Type not supported: " + (Object)((Object)constraint.constraintType()));
            }
        }
        Iterator<String> columnIterator = Arrays.asList(constraint.constraintColumns()).iterator();
        constraintDef.append("(");
        while (columnIterator.hasNext()) {
            String columnName = columnIterator.next();
            constraintDef.append(columnName);
            if (!columnIterator.hasNext()) continue;
            constraintDef.append(", ");
        }
        constraintDef.append(")");
        return constraintDef;
    }
}

