/*
 * Decompiled with CFR 0.152.
 */
package za.co.cporm.model;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import za.co.cporm.model.ModelFactory;
import za.co.cporm.model.generate.TableDetails;
import za.co.cporm.model.generate.TableGenerator;
import za.co.cporm.model.generate.TableView;
import za.co.cporm.model.generate.TableViewGenerator;
import za.co.cporm.model.util.CPOrmCursorFactory;
import za.co.cporm.model.util.ManifestHelper;
import za.co.cporm.model.util.TableDetailsCache;

public class CPOrmDatabase
extends SQLiteOpenHelper {
    private static final String TAG = "CPOrmDatabase";
    private final Context context;
    private final ModelFactory modelFactory;
    private final TableDetailsCache tableDetailsCache;

    public CPOrmDatabase(Context context) {
        super(context, ManifestHelper.getDatabaseName(context), (SQLiteDatabase.CursorFactory)new CPOrmCursorFactory(ManifestHelper.getDebugEnabled(context)), ManifestHelper.getDatabaseVersion(context));
        this.modelFactory = ManifestHelper.getModelFactory(context);
        this.context = context;
        this.tableDetailsCache = new TableDetailsCache();
        this.tableDetailsCache.init(context, this.modelFactory.getDataModelObjects());
    }

    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        for (Class<?> dataModelObject : this.modelFactory.getDataModelObjects()) {
            String createStatement;
            if (TableView.class.isAssignableFrom(dataModelObject)) {
                createStatement = TableViewGenerator.createViewStatement(this.findTableDetails(dataModelObject), dataModelObject);
                Log.d((String)TAG, (String)("Creating View: " + createStatement));
                sqLiteDatabase.execSQL(createStatement);
                continue;
            }
            createStatement = TableGenerator.generateTableCreate(this.findTableDetails(dataModelObject), false);
            Log.d((String)TAG, (String)("Creating Table: " + createStatement));
            sqLiteDatabase.execSQL(createStatement);
        }
    }

    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int i, int i1) {
        for (Class<?> dataModelObject : this.modelFactory.getDataModelObjects()) {
            String statement;
            if (TableView.class.isAssignableFrom(dataModelObject)) {
                statement = TableViewGenerator.createDropViewStatement(this.findTableDetails(dataModelObject));
                Log.d((String)TAG, (String)("Dropping View: " + statement));
                sqLiteDatabase.execSQL(statement);
                continue;
            }
            statement = TableGenerator.generateTableDrop(this.findTableDetails(dataModelObject), false);
            Log.d((String)TAG, (String)("Dropping Table: " + statement));
            sqLiteDatabase.execSQL(statement);
        }
        this.onCreate(sqLiteDatabase);
    }

    private TableDetails findTableDetails(Class<?> object) {
        return this.tableDetailsCache.findTableDetails(this.context, object);
    }

    public TableDetailsCache getTableDetailsCache() {
        return this.tableDetailsCache;
    }

    public ModelFactory getModelFactory() {
        return this.modelFactory;
    }
}

