/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline_embedded.console;

import scala.tools.jline_embedded.internal.Preconditions;

public class CursorBuffer {
    private boolean overTyping = false;
    public int cursor = 0;
    public final StringBuilder buffer = new StringBuilder();

    public CursorBuffer copy() {
        CursorBuffer that2 = new CursorBuffer();
        that2.overTyping = this.overTyping;
        that2.cursor = this.cursor;
        that2.buffer.append(this.toString());
        return that2;
    }

    public boolean isOverTyping() {
        return this.overTyping;
    }

    public void setOverTyping(boolean b2) {
        this.overTyping = b2;
    }

    public int length() {
        return this.buffer.length();
    }

    public char nextChar() {
        if (this.cursor == this.buffer.length()) {
            return '\u0000';
        }
        return this.buffer.charAt(this.cursor);
    }

    public char current() {
        if (this.cursor <= 0) {
            return '\u0000';
        }
        return this.buffer.charAt(this.cursor - 1);
    }

    public void write(char c) {
        this.buffer.insert(this.cursor++, c);
        if (this.isOverTyping() && this.cursor < this.buffer.length()) {
            this.buffer.deleteCharAt(this.cursor);
        }
    }

    public void write(CharSequence str) {
        Preconditions.checkNotNull(str);
        if (this.buffer.length() == 0) {
            this.buffer.append(str);
        } else {
            this.buffer.insert(this.cursor, str);
        }
        this.cursor += str.length();
        if (this.isOverTyping() && this.cursor < this.buffer.length()) {
            this.buffer.delete(this.cursor, this.cursor + str.length());
        }
    }

    public boolean clear() {
        if (this.buffer.length() == 0) {
            return false;
        }
        this.buffer.delete(0, this.buffer.length());
        this.cursor = 0;
        return true;
    }

    public String upToCursor() {
        if (this.cursor <= 0) {
            return "";
        }
        return this.buffer.substring(0, this.cursor);
    }

    public String toString() {
        return this.buffer.toString();
    }
}

