/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline_embedded.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import scala.tools.jline_embedded.console.KeyMap;
import scala.tools.jline_embedded.console.Operation;
import scala.tools.jline_embedded.internal.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleKeys {
    private KeyMap keys;
    private Map<String, KeyMap> keyMaps;
    private Map<String, String> variables = new HashMap<String, String>();

    public ConsoleKeys(String appName, URL inputrcUrl) {
        this.keyMaps = KeyMap.keyMaps();
        this.setVar("editing-mode", "emacs");
        this.loadKeys(appName, inputrcUrl);
    }

    protected boolean setKeyMap(String name) {
        KeyMap map2 = this.keyMaps.get(name);
        if (map2 == null) {
            return false;
        }
        this.keys = map2;
        return true;
    }

    protected Map<String, KeyMap> getKeyMaps() {
        return this.keyMaps;
    }

    protected KeyMap getKeys() {
        return this.keys;
    }

    protected void setKeys(KeyMap keys2) {
        this.keys = keys2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeys(String appName, URL inputrcUrl) {
        this.keys = this.keyMaps.get("emacs");
        try {
            InputStream input2 = inputrcUrl.openStream();
            try {
                this.loadKeys(input2, appName);
                Log.debug("Loaded user configuration: ", inputrcUrl);
            }
            finally {
                try {
                    input2.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            if (inputrcUrl.getProtocol().equals("file")) {
                File file = new File(inputrcUrl.getPath());
                if (file.exists()) {
                    Log.warn("Unable to read user configuration: ", inputrcUrl, e);
                }
            }
            Log.warn("Unable to read user configuration: ", inputrcUrl, e);
        }
    }

    private void loadKeys(InputStream input2, String appName) throws IOException {
        String line2;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input2));
        boolean parsing = true;
        ArrayList<Boolean> ifsStack = new ArrayList<Boolean>();
        while ((line2 = reader.readLine()) != null) {
            try {
                String val;
                if ((line2 = line2.trim()).length() == 0 || line2.charAt(0) == '#') continue;
                int i = 0;
                if (line2.charAt(i) == '$') {
                    ++i;
                    while (i < line2.length() && (line2.charAt(i) == ' ' || line2.charAt(i) == '\t')) {
                        ++i;
                    }
                    int s2 = i;
                    while (i < line2.length() && line2.charAt(i) != ' ' && line2.charAt(i) != '\t') {
                        ++i;
                    }
                    String cmd = line2.substring(s2, i);
                    while (i < line2.length() && (line2.charAt(i) == ' ' || line2.charAt(i) == '\t')) {
                        ++i;
                    }
                    s2 = i;
                    while (i < line2.length() && line2.charAt(i) != ' ' && line2.charAt(i) != '\t') {
                        ++i;
                    }
                    String args2 = line2.substring(s2, i);
                    if ("if".equalsIgnoreCase(cmd)) {
                        ifsStack.add(parsing);
                        if (!parsing || args2.startsWith("term=")) continue;
                        if (args2.startsWith("mode=")) {
                            String mode = this.variables.get("editing-mode");
                            parsing = args2.substring("mode=".length()).equalsIgnoreCase(mode);
                            continue;
                        }
                        parsing = args2.equalsIgnoreCase(appName);
                        continue;
                    }
                    if ("else".equalsIgnoreCase(cmd)) {
                        if (ifsStack.isEmpty()) {
                            throw new IllegalArgumentException("$else found without matching $if");
                        }
                        boolean invert = true;
                        Iterator iterator2 = ifsStack.iterator();
                        while (iterator2.hasNext()) {
                            boolean b2 = (Boolean)iterator2.next();
                            if (b2) continue;
                            invert = false;
                            break;
                        }
                        if (!invert) continue;
                        parsing = !parsing;
                        continue;
                    }
                    if ("endif".equalsIgnoreCase(cmd)) {
                        if (ifsStack.isEmpty()) {
                            throw new IllegalArgumentException("endif found without matching $if");
                        }
                        parsing = (Boolean)ifsStack.remove(ifsStack.size() - 1);
                        continue;
                    }
                    if (!"include".equalsIgnoreCase(cmd)) continue;
                }
                if (!parsing) continue;
                String keySeq = "";
                if (line2.charAt(i++) == '\"') {
                    boolean esc = false;
                    while (true) {
                        if (i >= line2.length()) {
                            throw new IllegalArgumentException("Missing closing quote on line '" + line2 + "'");
                        }
                        if (esc) {
                            esc = false;
                        } else if (line2.charAt(i) == '\\') {
                            esc = true;
                        } else if (line2.charAt(i) == '\"') break;
                        ++i;
                    }
                }
                while (i < line2.length() && line2.charAt(i) != ':' && line2.charAt(i) != ' ' && line2.charAt(i) != '\t') {
                    ++i;
                }
                keySeq = line2.substring(0, i);
                boolean equivalency = i + 1 < line2.length() && line2.charAt(i) == ':' && line2.charAt(i + 1) == '=';
                ++i;
                if (equivalency) {
                    ++i;
                }
                if (keySeq.equalsIgnoreCase("set")) {
                    while (i < line2.length() && (line2.charAt(i) == ' ' || line2.charAt(i) == '\t')) {
                        ++i;
                    }
                    int s3 = i;
                    while (i < line2.length() && line2.charAt(i) != ' ' && line2.charAt(i) != '\t') {
                        ++i;
                    }
                    String key = line2.substring(s3, i);
                    while (i < line2.length() && (line2.charAt(i) == ' ' || line2.charAt(i) == '\t')) {
                        ++i;
                    }
                    s3 = i;
                    while (i < line2.length() && line2.charAt(i) != ' ' && line2.charAt(i) != '\t') {
                        ++i;
                    }
                    val = line2.substring(s3, i);
                    this.setVar(key, val);
                    continue;
                }
                while (i < line2.length() && (line2.charAt(i) == ' ' || line2.charAt(i) == '\t')) {
                    ++i;
                }
                int start2 = i;
                if (i < line2.length() && (line2.charAt(i) == '\'' || line2.charAt(i) == '\"')) {
                    char delim = line2.charAt(i++);
                    boolean esc = false;
                    while (i < line2.length()) {
                        if (esc) {
                            esc = false;
                        } else if (line2.charAt(i) == '\\') {
                            esc = true;
                        } else if (line2.charAt(i) == delim) break;
                        ++i;
                    }
                }
                while (i < line2.length() && line2.charAt(i) != ' ' && line2.charAt(i) != '\t') {
                    ++i;
                }
                val = line2.substring(Math.min(start2, line2.length()), Math.min(i, line2.length()));
                if (keySeq.charAt(0) == '\"') {
                    keySeq = ConsoleKeys.translateQuoted(keySeq);
                } else {
                    String keyName = keySeq.lastIndexOf(45) > 0 ? keySeq.substring(keySeq.lastIndexOf(45) + 1) : keySeq;
                    char key = ConsoleKeys.getKeyFromName(keyName);
                    keyName = keySeq.toLowerCase();
                    keySeq = "";
                    if (keyName.contains("meta-") || keyName.contains("m-")) {
                        keySeq = keySeq + "\u001b";
                    }
                    if (keyName.contains("control-") || keyName.contains("c-") || keyName.contains("ctrl-")) {
                        key = (char)(Character.toUpperCase(key) & 0x1F);
                    }
                    keySeq = keySeq + key;
                }
                if (val.length() > 0 && (val.charAt(0) == '\'' || val.charAt(0) == '\"')) {
                    this.keys.bind(keySeq, ConsoleKeys.translateQuoted(val));
                    continue;
                }
                String operationName = val.replace('-', '_').toUpperCase();
                try {
                    this.keys.bind(keySeq, (Object)Operation.valueOf(operationName));
                }
                catch (IllegalArgumentException e) {
                    Log.info("Unable to bind key for unsupported operation: ", val);
                }
            }
            catch (IllegalArgumentException e) {
                Log.warn("Unable to parse user configuration: ", e);
            }
        }
    }

    private static String translateQuoted(String keySeq) {
        String str = keySeq.substring(1, keySeq.length() - 1);
        keySeq = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                boolean meta;
                boolean ctrl = str.regionMatches(i, "\\C-", 0, 3) || str.regionMatches(i, "\\M-\\C-", 0, 6);
                if ((i += ((meta = str.regionMatches(i, "\\M-", 0, 3) || str.regionMatches(i, "\\C-\\M-", 0, 6)) ? 3 : 0) + (ctrl ? 3 : 0) + (!meta && !ctrl ? 1 : 0)) >= str.length()) break;
                c = str.charAt(i);
                if (meta) {
                    keySeq = keySeq + "\u001b";
                }
                if (ctrl) {
                    char c2 = c = c == '?' ? (char)'\u007f' : (char)(Character.toUpperCase(c) & 0x1F);
                }
                if (!meta && !ctrl) {
                    switch (c) {
                        case 'a': {
                            c = '\u0007';
                            break;
                        }
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'd': {
                            c = '\u007f';
                            break;
                        }
                        case 'e': {
                            c = '\u001b';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'v': {
                            c = '\u000b';
                            break;
                        }
                        case '\\': {
                            c = '\\';
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int k;
                            int j;
                            c = '\u0000';
                            for (j = 0; j < 3 && i < str.length() && (k = Character.digit(str.charAt(i), 8)) >= 0; ++j, ++i) {
                                c = (char)(c * 8 + k);
                            }
                            c = (char)(c & 0xFF);
                            break;
                        }
                        case 'x': {
                            int k;
                            int j;
                            ++i;
                            c = '\u0000';
                            for (j = 0; j < 2 && i < str.length() && (k = Character.digit(str.charAt(i), 16)) >= 0; ++j, ++i) {
                                c = (char)(c * 16 + k);
                            }
                            c = (char)(c & 0xFF);
                            break;
                        }
                        case 'u': {
                            int k;
                            int j;
                            ++i;
                            c = '\u0000';
                            for (j = 0; j < 4 && i < str.length() && (k = Character.digit(str.charAt(i), 16)) >= 0; ++j, ++i) {
                                c = (char)(c * 16 + k);
                            }
                            break;
                        }
                    }
                }
                keySeq = keySeq + c;
                continue;
            }
            keySeq = keySeq + c;
        }
        return keySeq;
    }

    private static char getKeyFromName(String name) {
        if ("DEL".equalsIgnoreCase(name) || "Rubout".equalsIgnoreCase(name)) {
            return '\u007f';
        }
        if ("ESC".equalsIgnoreCase(name) || "Escape".equalsIgnoreCase(name)) {
            return '\u001b';
        }
        if ("LFD".equalsIgnoreCase(name) || "NewLine".equalsIgnoreCase(name)) {
            return '\n';
        }
        if ("RET".equalsIgnoreCase(name) || "Return".equalsIgnoreCase(name)) {
            return '\r';
        }
        if ("SPC".equalsIgnoreCase(name) || "Space".equalsIgnoreCase(name)) {
            return ' ';
        }
        if ("Tab".equalsIgnoreCase(name)) {
            return '\t';
        }
        return name.charAt(0);
    }

    private void setVar(String key, String val) {
        if ("keymap".equalsIgnoreCase(key)) {
            if (this.keyMaps.containsKey(val)) {
                this.keys = this.keyMaps.get(val);
            }
        } else if ("editing-mode".equals(key)) {
            if ("vi".equalsIgnoreCase(val)) {
                this.keys = this.keyMaps.get("vi-insert");
            } else if ("emacs".equalsIgnoreCase(key)) {
                this.keys = this.keyMaps.get("emacs");
            }
        } else if ("blink-matching-paren".equals(key)) {
            if ("on".equalsIgnoreCase(val)) {
                this.keys.setBlinkMatchingParen(true);
            } else if ("off".equalsIgnoreCase(val)) {
                this.keys.setBlinkMatchingParen(false);
            }
        }
        this.variables.put(key, val);
    }

    public String getVariable(String var) {
        return this.variables.get(var);
    }
}

