/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.fusesource_embedded.jansi;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import scala.tools.fusesource_embedded.jansi.AnsiOutputStream;
import scala.tools.fusesource_embedded.jansi.WindowsAnsiOutputStream;
import scala.tools.fusesource_embedded.jansi.internal.CLibrary;

public class AnsiConsole {
    public static final PrintStream system_out = System.out;
    public static final PrintStream out = new PrintStream(AnsiConsole.wrapOutputStream(system_out));
    public static final PrintStream system_err = System.err;
    public static final PrintStream err = new PrintStream(AnsiConsole.wrapOutputStream(system_err, CLibrary.STDERR_FILENO));
    private static int installed;

    private AnsiConsole() {
    }

    public static OutputStream wrapOutputStream(OutputStream stream2) {
        return AnsiConsole.wrapOutputStream(stream2, CLibrary.STDOUT_FILENO);
    }

    public static OutputStream wrapOutputStream(OutputStream stream2, int fileno) {
        if (Boolean.getBoolean("jansi.passthrough")) {
            return stream2;
        }
        if (Boolean.getBoolean("jansi.strip")) {
            return new AnsiOutputStream(stream2);
        }
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows") && !AnsiConsole.isCygwin()) {
            try {
                return new WindowsAnsiOutputStream(stream2);
            }
            catch (Throwable ignore2) {
                return new AnsiOutputStream(stream2);
            }
        }
        try {
            boolean forceColored = Boolean.getBoolean("jansi.force");
            int rc = CLibrary.isatty(fileno);
            if (!AnsiConsole.isCygwin() && !forceColored && rc == 0) {
                return new AnsiOutputStream(stream2);
            }
        }
        catch (NoClassDefFoundError ignore3) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return new FilterOutputStream(stream2){

            public void close() throws IOException {
                this.write(AnsiOutputStream.REST_CODE);
                this.flush();
                super.close();
            }
        };
    }

    private static boolean isCygwin() {
        String term = System.getenv("TERM");
        return term != null && term.equals("xterm");
    }

    public static PrintStream out() {
        return out;
    }

    public static PrintStream err() {
        return err;
    }

    public static synchronized void systemInstall() {
        if (++installed == 1) {
            System.setOut(out);
            System.setErr(err);
        }
    }

    public static synchronized void systemUninstall() {
        if (--installed == 0) {
            System.setOut(system_out);
            System.setErr(system_err);
        }
    }
}

