/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.RedBlackTree;
import scala.collection.immutable.RedBlackTree$BlackTree$;
import scala.collection.immutable.RedBlackTree$NList$;
import scala.collection.immutable.RedBlackTree$RedTree$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class RedBlackTree$ {
    public static final RedBlackTree$ MODULE$;

    static {
        new RedBlackTree$();
    }

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree2) {
        return tree2 == null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree2, A x, Ordering<A> evidence$1) {
        return this.lookup(tree2, x, evidence$1) != null;
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree2, A x, Ordering<A> evidence$2) {
        RedBlackTree.Tree<A, B> tree3 = this.lookup(tree2, x, evidence$2);
        Option option2 = tree3 == null ? None$.MODULE$ : new Some<B>(tree3.value());
        return option2;
    }

    public <A, B> RedBlackTree.Tree<A, B> lookup(RedBlackTree.Tree<A, B> tree2, A x, Ordering<A> ordering2) {
        RedBlackTree.Tree<A, B> tree3;
        block3: {
            while (true) {
                if (tree2 == null) {
                    tree3 = null;
                    break block3;
                }
                int cmp = ordering2.compare(x, tree2.key());
                if (cmp < 0) {
                    tree2 = tree2.left();
                    continue;
                }
                if (cmp <= 0) break;
                tree2 = tree2.right();
            }
            tree3 = tree2;
        }
        return tree3;
    }

    public int count(RedBlackTree.Tree<?, ?> tree2) {
        return tree2 == null ? 0 : tree2.count();
    }

    public <A> int countInRange(RedBlackTree.Tree<A, ?> tree2, Option<A> from2, Option<A> to2, Ordering<A> ordering2) {
        int n;
        block5: {
            int n2;
            block6: {
                while (true) {
                    if (tree2 == null) {
                        n = 0;
                        break block5;
                    }
                    Tuple2<Option<A>, Option<A>> tuple23 = new Tuple2<Option<A>, Option<A>>(from2, to2);
                    if (None$.MODULE$.equals(tuple23._1()) && None$.MODULE$.equals(tuple23._2())) {
                        n2 = tree2.count();
                        break block6;
                    }
                    if (tuple23._1() instanceof Some) {
                        Some some2 = (Some)tuple23._1();
                        if (ordering2.lt(tree2.key(), some2.x())) {
                            tree2 = tree2.right();
                            continue;
                        }
                    }
                    if (!(tuple23._2() instanceof Some)) break;
                    Some some3 = (Some)tuple23._2();
                    if (!ordering2.gteq(tree2.key(), some3.x())) break;
                    tree2 = tree2.left();
                }
                n2 = 1 + this.countInRange(tree2.left(), from2, None$.MODULE$, ordering2) + this.countInRange(tree2.right(), None$.MODULE$, to2, ordering2);
            }
            n = n2;
        }
        return n;
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> update(RedBlackTree.Tree<A, B> tree2, A k, B1 v, boolean overwrite, Ordering<A> evidence$3) {
        return this.blacken(this.upd(tree2, k, v, overwrite, evidence$3));
    }

    public <A, B> RedBlackTree.Tree<A, B> delete(RedBlackTree.Tree<A, B> tree2, A k, Ordering<A> evidence$4) {
        return this.blacken(this.del(tree2, k, evidence$4));
    }

    public <A, B> RedBlackTree.Tree<A, B> rangeImpl(RedBlackTree.Tree<A, B> tree2, Option<A> from2, Option<A> until2, Ordering<A> evidence$5) {
        Tuple2<Option<A>, Option<A>> tuple23;
        block6: {
            RedBlackTree.Tree<A, B> tree3;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            tuple23 = new Tuple2<Option<A>, Option<A>>(from2, until2);
                            if (!(tuple23._1() instanceof Some)) break block2;
                            Some some2 = (Some)tuple23._1();
                            if (!(tuple23._2() instanceof Some)) break block2;
                            Some some3 = (Some)tuple23._2();
                            tree3 = this.range(tree2, some2.x(), some3.x(), evidence$5);
                            break block3;
                        }
                        if (!(tuple23._1() instanceof Some)) break block4;
                        Some some4 = (Some)tuple23._1();
                        if (!None$.MODULE$.equals(tuple23._2())) break block4;
                        tree3 = this.from(tree2, some4.x(), evidence$5);
                        break block3;
                    }
                    if (!None$.MODULE$.equals(tuple23._1()) || !(tuple23._2() instanceof Some)) break block5;
                    Some some5 = (Some)tuple23._2();
                    tree3 = this.until(tree2, some5.x(), evidence$5);
                    break block3;
                }
                if (!None$.MODULE$.equals(tuple23._1()) || !None$.MODULE$.equals(tuple23._2())) break block6;
                tree3 = tree2;
            }
            return tree3;
        }
        throw new MatchError(tuple23);
    }

    public <A, B> RedBlackTree.Tree<A, B> range(RedBlackTree.Tree<A, B> tree2, A from2, A until2, Ordering<A> evidence$6) {
        return this.blacken(this.doRange(tree2, from2, until2, evidence$6));
    }

    public <A, B> RedBlackTree.Tree<A, B> from(RedBlackTree.Tree<A, B> tree2, A from2, Ordering<A> evidence$7) {
        return this.blacken(this.doFrom(tree2, from2, evidence$7));
    }

    public <A, B> RedBlackTree.Tree<A, B> to(RedBlackTree.Tree<A, B> tree2, A to2, Ordering<A> evidence$8) {
        return this.blacken(this.doTo(tree2, to2, evidence$8));
    }

    public <A, B> RedBlackTree.Tree<A, B> until(RedBlackTree.Tree<A, B> tree2, A key, Ordering<A> evidence$9) {
        return this.blacken(this.doUntil(tree2, key, evidence$9));
    }

    public <A, B> RedBlackTree.Tree<A, B> drop(RedBlackTree.Tree<A, B> tree2, int n, Ordering<A> evidence$10) {
        return this.blacken(this.doDrop(tree2, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> take(RedBlackTree.Tree<A, B> tree2, int n, Ordering<A> evidence$11) {
        return this.blacken(this.doTake(tree2, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> slice(RedBlackTree.Tree<A, B> tree2, int from2, int until2, Ordering<A> evidence$12) {
        return this.blacken(this.doSlice(tree2, from2, until2));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> smallest(RedBlackTree.Tree<A, B> tree2) {
        void var2_2;
        if (tree2 == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result2 = tree2;
        while (result2.left() != null) {
            result2 = result2.left();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> greatest(RedBlackTree.Tree<A, B> tree2) {
        void var2_2;
        if (tree2 == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result2 = tree2;
        while (result2.right() != null) {
            result2 = result2.right();
        }
        return var2_2;
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree2, Function1<Tuple2<A, B>, U> f2) {
        if (tree2 != null) {
            this._foreach(tree2, f2);
        }
    }

    private <A, B, U> void _foreach(RedBlackTree.Tree<A, B> tree2, Function1<Tuple2<A, B>, U> f2) {
        while (true) {
            if (tree2.left() != null) {
                this._foreach(tree2.left(), f2);
            }
            f2.apply(new Tuple2<A, B>(tree2.key(), tree2.value()));
            if (tree2.right() == null) break;
            tree2 = tree2.right();
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree2, Function1<A, U> f2) {
        if (tree2 != null) {
            this._foreachKey(tree2, f2);
        }
    }

    private <A, U> void _foreachKey(RedBlackTree.Tree<A, ?> tree2, Function1<A, U> f2) {
        while (true) {
            if (tree2.left() != null) {
                this._foreachKey(tree2.left(), f2);
            }
            f2.apply(tree2.key());
            if (tree2.right() == null) break;
            tree2 = tree2.right();
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree2, Option<A> start2, Ordering<A> evidence$13) {
        return new RedBlackTree.EntriesIterator<A, B>(tree2, start2, evidence$13);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree2, Option<A> start2, Ordering<A> evidence$14) {
        return new RedBlackTree.KeysIterator(tree2, start2, evidence$14);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree2, Option<A> start2, Ordering<A> evidence$15) {
        return new RedBlackTree.ValuesIterator<A, B>(tree2, start2, evidence$15);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> RedBlackTree.Tree<A, B> nth(RedBlackTree.Tree<A, B> tree2, int n) {
        while (true) {
            int count2;
            if (n < (count2 = this.count(tree2.left()))) {
                tree2 = tree2.left();
                continue;
            }
            if (n <= count2) break;
            n = n - count2 - 1;
            tree2 = tree2.right();
        }
        return tree2;
    }

    public boolean isBlack(RedBlackTree.Tree<?, ?> tree2) {
        return tree2 == null || this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree2);
    }

    private boolean isRedTree(RedBlackTree.Tree<?, ?> tree2) {
        return tree2 instanceof RedBlackTree.RedTree;
    }

    public boolean scala$collection$immutable$RedBlackTree$$isBlackTree(RedBlackTree.Tree<?, ?> tree2) {
        return tree2 instanceof RedBlackTree.BlackTree;
    }

    private <A, B> RedBlackTree.Tree<A, B> blacken(RedBlackTree.Tree<A, B> t) {
        return t == null ? null : t.black();
    }

    private <A, B> RedBlackTree.Tree<A, B> mkTree(boolean isBlack, A k, B v, RedBlackTree.Tree<A, B> l, RedBlackTree.Tree<A, B> r) {
        RedBlackTree.Tree tree2;
        if (isBlack) {
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            tree2 = new RedBlackTree.BlackTree<A, B>(k, v, l, r);
        } else {
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            tree2 = new RedBlackTree.RedTree<A, B>(k, v, l, r);
        }
        return tree2;
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> scala$collection$immutable$RedBlackTree$$balanceLeft(boolean isBlack, A z2, B zv, RedBlackTree.Tree<A, B1> l, RedBlackTree.Tree<A, B1> d) {
        RedBlackTree.RedTree<A, B1> redTree;
        if (this.isRedTree(l) && this.isRedTree(l.left())) {
            RedBlackTree.Tree<A, B1> tree2 = l.left().right();
            RedBlackTree.Tree<A, B1> tree3 = l.left().left();
            B1 B1 = l.left().value();
            A a2 = l.left().key();
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B1> tree4 = l.right();
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.BlackTree<A, B> blackTree = new RedBlackTree.BlackTree<A, B>(z2, zv, tree4, d);
            RedBlackTree.BlackTree<A, B1> blackTree2 = new RedBlackTree.BlackTree<A, B1>(a2, B1, tree3, tree2);
            B1 B12 = l.value();
            A a3 = l.key();
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            redTree = new RedBlackTree.RedTree<A, B1>(a3, B12, blackTree2, blackTree);
        } else if (this.isRedTree(l) && this.isRedTree(l.right())) {
            RedBlackTree.Tree<A, B1> tree5 = l.right().left();
            RedBlackTree.Tree<A, B1> tree6 = l.left();
            B1 B1 = l.value();
            A a4 = l.key();
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B1> tree7 = l.right().right();
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$3 = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.BlackTree<A, B> blackTree = new RedBlackTree.BlackTree<A, B>(z2, zv, tree7, d);
            RedBlackTree.BlackTree<A, B1> blackTree3 = new RedBlackTree.BlackTree<A, B1>(a4, B1, tree6, tree5);
            B1 B13 = l.right().value();
            A a5 = l.right().key();
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            redTree = new RedBlackTree.RedTree<A, B1>(a5, B13, blackTree3, blackTree);
        } else {
            redTree = this.mkTree(isBlack, z2, zv, l, d);
        }
        return redTree;
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> scala$collection$immutable$RedBlackTree$$balanceRight(boolean isBlack, A x, B xv, RedBlackTree.Tree<A, B1> a2, RedBlackTree.Tree<A, B1> r) {
        RedBlackTree.RedTree<A, B1> redTree;
        if (this.isRedTree(r) && this.isRedTree(r.left())) {
            RedBlackTree.Tree<A, B1> tree2 = r.left().left();
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B1> tree3 = r.right();
            RedBlackTree.Tree<A, B1> tree4 = r.left().right();
            B1 B1 = r.value();
            A a3 = r.key();
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.BlackTree<A, B1> blackTree = new RedBlackTree.BlackTree<A, B1>(a3, B1, tree4, tree3);
            RedBlackTree.BlackTree<A, B> blackTree2 = new RedBlackTree.BlackTree<A, B>(x, xv, a2, tree2);
            B1 B12 = r.left().value();
            A a4 = r.left().key();
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            redTree = new RedBlackTree.RedTree<A, B1>(a4, B12, blackTree2, blackTree);
        } else if (this.isRedTree(r) && this.isRedTree(r.right())) {
            RedBlackTree.Tree<A, B1> tree5 = r.left();
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.Tree<A, B1> tree6 = r.right().right();
            RedBlackTree.Tree<A, B1> tree7 = r.right().left();
            B1 B1 = r.right().value();
            A a5 = r.right().key();
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$3 = RedBlackTree$BlackTree$.MODULE$;
            RedBlackTree.BlackTree<A, B1> blackTree = new RedBlackTree.BlackTree<A, B1>(a5, B1, tree7, tree6);
            RedBlackTree.BlackTree<A, B> blackTree3 = new RedBlackTree.BlackTree<A, B>(x, xv, a2, tree5);
            B1 B13 = r.value();
            A a6 = r.key();
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            redTree = new RedBlackTree.RedTree<A, B1>(a6, B13, blackTree3, blackTree);
        } else {
            redTree = this.mkTree(isBlack, x, xv, a2, r);
        }
        return redTree;
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> upd(RedBlackTree.Tree<A, B> tree2, A k, B1 v, boolean overwrite, Ordering<A> ordering2) {
        RedBlackTree.Tree tree3;
        if (tree2 == null) {
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            tree3 = new RedBlackTree.RedTree<A, B1>(k, v, null, null);
        } else {
            A a2;
            int cmp = ordering2.compare(k, tree2.key());
            tree3 = cmp < 0 ? this.scala$collection$immutable$RedBlackTree$$balanceLeft(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree2), tree2.key(), tree2.value(), this.upd(tree2.left(), k, v, overwrite, ordering2), tree2.right()) : (cmp > 0 ? this.scala$collection$immutable$RedBlackTree$$balanceRight(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree2), tree2.key(), tree2.value(), tree2.left(), this.upd(tree2.right(), k, v, overwrite, ordering2)) : (!overwrite && (k == (a2 = tree2.key()) ? true : (k == null ? false : (k instanceof Number ? BoxesRunTime.equalsNumObject((Number)k, a2) : (k instanceof Character ? BoxesRunTime.equalsCharObject((Character)k, a2) : k.equals(a2))))) ? tree2 : this.mkTree(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree2), k, v, tree2.left(), tree2.right())));
        }
        return tree3;
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> updNth(RedBlackTree.Tree<A, B> tree2, int idx, A k, B1 v, boolean overwrite) {
        RedBlackTree.Tree tree3;
        if (tree2 == null) {
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            tree3 = new RedBlackTree.RedTree<A, B1>(k, v, null, null);
        } else {
            int rank = this.count(tree2.left()) + 1;
            tree3 = idx < rank ? this.scala$collection$immutable$RedBlackTree$$balanceLeft(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree2), tree2.key(), tree2.value(), this.updNth(tree2.left(), idx, k, v, overwrite), tree2.right()) : (idx > rank ? this.scala$collection$immutable$RedBlackTree$$balanceRight(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree2), tree2.key(), tree2.value(), tree2.left(), this.updNth(tree2.right(), idx - rank, k, v, overwrite)) : (overwrite ? this.mkTree(this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree2), k, v, tree2.left(), tree2.right()) : tree2));
        }
        return tree3;
    }

    private <A, B> RedBlackTree.Tree<A, B> del(RedBlackTree.Tree<A, B> tree2, A k, Ordering<A> ordering2) {
        int cmp;
        return tree2 == null ? null : ((cmp = ordering2.compare(k, tree2.key())) < 0 ? this.delLeft$1(tree2, k, ordering2) : (cmp > 0 ? this.delRight$1(tree2, k, ordering2) : this.append$1(tree2.left(), tree2.right())));
    }

    private <A, B> RedBlackTree.Tree<A, B> doFrom(RedBlackTree.Tree<A, B> tree2, A from2, Ordering<A> ordering2) {
        if (tree2 == null) {
            return null;
        }
        if (ordering2.lt(tree2.key(), from2)) {
            return this.doFrom(tree2.right(), from2, ordering2);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree2.left(), from2, ordering2);
        return newLeft == tree2.left() ? tree2 : (newLeft == null ? this.upd(tree2.right(), tree2.key(), tree2.value(), false, ordering2) : this.rebalance(tree2, newLeft, tree2.right()));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTo(RedBlackTree.Tree<A, B> tree2, A to2, Ordering<A> ordering2) {
        if (tree2 == null) {
            return null;
        }
        if (ordering2.lt(to2, tree2.key())) {
            return this.doTo(tree2.left(), to2, ordering2);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTo(tree2.right(), to2, ordering2);
        return newRight == tree2.right() ? tree2 : (newRight == null ? this.upd(tree2.left(), tree2.key(), tree2.value(), false, ordering2) : this.rebalance(tree2, tree2.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doUntil(RedBlackTree.Tree<A, B> tree2, A until2, Ordering<A> ordering2) {
        if (tree2 == null) {
            return null;
        }
        if (ordering2.lteq(until2, tree2.key())) {
            return this.doUntil(tree2.left(), until2, ordering2);
        }
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree2.right(), until2, ordering2);
        return newRight == tree2.right() ? tree2 : (newRight == null ? this.upd(tree2.left(), tree2.key(), tree2.value(), false, ordering2) : this.rebalance(tree2, tree2.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doRange(RedBlackTree.Tree<A, B> tree2, A from2, A until2, Ordering<A> ordering2) {
        if (tree2 == null) {
            return null;
        }
        if (ordering2.lt(tree2.key(), from2)) {
            return this.doRange(tree2.right(), from2, until2, ordering2);
        }
        if (ordering2.lteq(until2, tree2.key())) {
            return this.doRange(tree2.left(), from2, until2, ordering2);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree2.left(), from2, ordering2);
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree2.right(), until2, ordering2);
        return newLeft == tree2.left() && newRight == tree2.right() ? tree2 : (newLeft == null ? this.upd(newRight, tree2.key(), tree2.value(), false, ordering2) : (newRight == null ? this.upd(newLeft, tree2.key(), tree2.value(), false, ordering2) : this.rebalance(tree2, newLeft, newRight)));
    }

    private <A, B> RedBlackTree.Tree<A, B> doDrop(RedBlackTree.Tree<A, B> tree2, int n) {
        if (n <= 0) {
            return tree2;
        }
        if (n >= this.count(tree2)) {
            return null;
        }
        int count2 = this.count(tree2.left());
        if (n > count2) {
            return this.doDrop(tree2.right(), n - count2 - 1);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree2.left(), n);
        return newLeft == tree2.left() ? tree2 : (newLeft == null ? this.updNth(tree2.right(), n - count2 - 1, tree2.key(), tree2.value(), false) : this.rebalance(tree2, newLeft, tree2.right()));
    }

    private <A, B> RedBlackTree.Tree<A, B> doTake(RedBlackTree.Tree<A, B> tree2, int n) {
        if (n <= 0) {
            return null;
        }
        if (n >= this.count(tree2)) {
            return tree2;
        }
        int count2 = this.count(tree2.left());
        if (n <= count2) {
            return this.doTake(tree2.left(), n);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree2.right(), n - count2 - 1);
        return newRight == tree2.right() ? tree2 : (newRight == null ? this.updNth(tree2.left(), n, tree2.key(), tree2.value(), false) : this.rebalance(tree2, tree2.left(), newRight));
    }

    private <A, B> RedBlackTree.Tree<A, B> doSlice(RedBlackTree.Tree<A, B> tree2, int from2, int until2) {
        if (tree2 == null) {
            return null;
        }
        int count2 = this.count(tree2.left());
        if (from2 > count2) {
            return this.doSlice(tree2.right(), from2 - count2 - 1, until2 - count2 - 1);
        }
        if (until2 <= count2) {
            return this.doSlice(tree2.left(), from2, until2);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree2.left(), from2);
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree2.right(), until2 - count2 - 1);
        return newLeft == tree2.left() && newRight == tree2.right() ? tree2 : (newLeft == null ? this.updNth(newRight, from2 - count2 - 1, tree2.key(), tree2.value(), false) : (newRight == null ? this.updNth(newLeft, until2, tree2.key(), tree2.value(), false) : this.rebalance(tree2, newLeft, newRight)));
    }

    private <A, B> Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> compareDepth(RedBlackTree.Tree<A, B> left2, RedBlackTree.Tree<A, B> right2) {
        return this.unzipBoth$1(left2, right2, null, null, 0);
    }

    private <A, B> RedBlackTree.Tree<A, B> rebalance(RedBlackTree.Tree<A, B> tree2, RedBlackTree.Tree<A, B> newLeft, RedBlackTree.Tree<A, B> newRight) {
        RedBlackTree.Tree<A, B> blkNewRight;
        RedBlackTree.Tree<A, B> blkNewLeft = this.blacken(newLeft);
        Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> tuple42 = this.compareDepth(blkNewLeft, blkNewRight = this.blacken(newRight));
        if (tuple42 != null) {
            RedBlackTree.Tree tree3;
            Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> tuple43 = new Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object>(tuple42._1(), tuple42._2(), tuple42._3(), tuple42._4());
            RedBlackTree.NList<RedBlackTree.Tree<A, B>> zipper = tuple43._1();
            boolean levelled = BoxesRunTime.unboxToBoolean(tuple43._2());
            boolean leftMost = BoxesRunTime.unboxToBoolean(tuple43._3());
            int smallerDepth = BoxesRunTime.unboxToInt(tuple43._4());
            if (levelled) {
                B b2 = tree2.value();
                A a2 = tree2.key();
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                tree3 = new RedBlackTree.BlackTree<A, B>(a2, b2, blkNewLeft, blkNewRight);
            } else {
                RedBlackTree.RedTree<A, B> redTree;
                RedBlackTree.NList zipFrom = this.findDepth$1(zipper, smallerDepth);
                if (leftMost) {
                    RedBlackTree.Tree tree4 = (RedBlackTree.Tree)zipFrom.head();
                    B b3 = tree2.value();
                    A a3 = tree2.key();
                    RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                    redTree = new RedBlackTree.RedTree<A, B>(a3, b3, blkNewLeft, tree4);
                } else {
                    RedBlackTree.Tree tree5 = (RedBlackTree.Tree)zipFrom.head();
                    B b4 = tree2.value();
                    A a4 = tree2.key();
                    RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                    redTree = new RedBlackTree.RedTree<A, B>(a4, b4, tree5, blkNewRight);
                }
                RedBlackTree.RedTree<A, B> union2 = redTree;
                RedBlackTree.Tree zippedTree = RedBlackTree$NList$.MODULE$.foldLeft(zipFrom.tail(), union2, new Serializable(leftMost){
                    public static final long serialVersionUID = 0L;
                    private final boolean leftMost$1;

                    public final RedBlackTree.Tree<A, B> apply(RedBlackTree.Tree<A, B> tree2, RedBlackTree.Tree<A, B> node4) {
                        return this.leftMost$1 ? RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$balanceLeft(RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$isBlackTree(node4), node4.key(), node4.value(), tree2, node4.right()) : RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$balanceRight(RedBlackTree$.MODULE$.scala$collection$immutable$RedBlackTree$$isBlackTree(node4), node4.key(), node4.value(), node4.left(), tree2);
                    }
                    {
                        this.leftMost$1 = leftMost$1;
                    }
                });
                tree3 = zippedTree;
            }
            return tree3;
        }
        throw new MatchError(tuple42);
    }

    private final RedBlackTree.Tree balance$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        RedBlackTree.Tree tree2;
        if (this.isRedTree(tl)) {
            if (this.isRedTree(tr)) {
                RedBlackTree.Tree tree3 = tr.black();
                RedBlackTree.Tree tree4 = tl.black();
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                tree2 = new RedBlackTree.RedTree<Object, Object>(x, xv, tree4, tree3);
            } else if (this.isRedTree(tl.left())) {
                RedBlackTree.Tree tree5 = tl.right();
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(x, xv, tree5, tr);
                RedBlackTree.Tree tree6 = tl.left().black();
                Object b2 = tl.value();
                Object a2 = tl.key();
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                tree2 = new RedBlackTree.RedTree<Object, Object>(a2, b2, tree6, blackTree);
            } else if (this.isRedTree(tl.right())) {
                RedBlackTree.Tree tree7 = tl.right().left();
                RedBlackTree.Tree tree8 = tl.left();
                Object b3 = tl.value();
                Object a3 = tl.key();
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.Tree tree9 = tl.right().right();
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(x, xv, tree9, tr);
                RedBlackTree.BlackTree blackTree2 = new RedBlackTree.BlackTree(a3, b3, tree8, tree7);
                Object b4 = tl.right().value();
                Object a4 = tl.right().key();
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                tree2 = new RedBlackTree.RedTree<Object, Object>(a4, b4, blackTree2, blackTree);
            } else {
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                tree2 = new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, tr);
            }
        } else if (this.isRedTree(tr)) {
            if (this.isRedTree(tr.right())) {
                RedBlackTree.Tree tree10 = tr.left();
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.Tree tree11 = tr.right().black();
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, tree10);
                Object b5 = tr.value();
                Object a5 = tr.key();
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                tree2 = new RedBlackTree.RedTree<Object, Object>(a5, b5, blackTree, tree11);
            } else if (this.isRedTree(tr.left())) {
                RedBlackTree.Tree tree12 = tr.left().left();
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.Tree tree13 = tr.right();
                RedBlackTree.Tree tree14 = tr.left().right();
                Object b6 = tr.value();
                Object a6 = tr.key();
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$3 = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.BlackTree blackTree = new RedBlackTree.BlackTree(a6, b6, tree14, tree13);
                RedBlackTree.BlackTree<Object, Object> blackTree3 = new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, tree12);
                Object b7 = tr.left().value();
                Object a7 = tr.left().key();
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                tree2 = new RedBlackTree.RedTree<Object, Object>(a7, b7, blackTree3, blackTree);
            } else {
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                tree2 = new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, tr);
            }
        } else {
            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
            tree2 = new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, tr);
        }
        return tree2;
    }

    private final RedBlackTree.Tree subl$1(RedBlackTree.Tree t) {
        if (t instanceof RedBlackTree.BlackTree) {
            return t.red();
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"Defect: invariance violation; expected black, got ").append(t).toString());
    }

    private final RedBlackTree.Tree balLeft$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        block5: {
            RedBlackTree.RedTree<Object, Object> redTree;
            block3: {
                block4: {
                    block2: {
                        if (!this.isRedTree(tl)) break block2;
                        RedBlackTree.Tree tree2 = tl.black();
                        RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                        redTree = new RedBlackTree.RedTree<Object, Object>(x, xv, tree2, tr);
                        break block3;
                    }
                    if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr)) break block4;
                    redTree = this.balance$1(x, xv, tl, tr.red());
                    break block3;
                }
                if (!this.isRedTree(tr) || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr.left())) break block5;
                RedBlackTree.Tree tree3 = tr.left().left();
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.Tree tree4 = this.balance$1(tr.key(), tr.value(), tr.left().right(), this.subl$1(tr.right()));
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, tree3);
                Object b2 = tr.left().value();
                Object a2 = tr.left().key();
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                redTree = new RedBlackTree.RedTree<Object, Object>(a2, b2, blackTree, tree4);
            }
            return redTree;
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private final RedBlackTree.Tree balRight$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        block5: {
            RedBlackTree.RedTree<Object, Object> redTree;
            block3: {
                block4: {
                    block2: {
                        if (!this.isRedTree(tr)) break block2;
                        RedBlackTree.Tree tree2 = tr.black();
                        RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                        redTree = new RedBlackTree.RedTree<Object, Object>(x, xv, tl, tree2);
                        break block3;
                    }
                    if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl)) break block4;
                    redTree = this.balance$1(x, xv, tl.red(), tr);
                    break block3;
                }
                if (!this.isRedTree(tl) || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl.right())) break block5;
                RedBlackTree.Tree tree3 = tl.right().right();
                RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(x, xv, tree3, tr);
                RedBlackTree.Tree tree4 = this.balance$1(tl.key(), tl.value(), this.subl$1(tl.left()), tl.right().left());
                Object b2 = tl.right().value();
                Object a2 = tl.right().key();
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                redTree = new RedBlackTree.RedTree<Object, Object>(a2, b2, tree4, blackTree);
            }
            return redTree;
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    private final RedBlackTree.Tree delLeft$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        RedBlackTree.Tree tree2;
        if (this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree$1.left())) {
            tree2 = this.balLeft$1(tree$1.key(), tree$1.value(), this.del(tree$1.left(), k$1, ordering$1), tree$1.right());
        } else {
            RedBlackTree.Tree tree3 = tree$1.right();
            RedBlackTree.Tree tree4 = this.del(tree$1.left(), k$1, ordering$1);
            Object b2 = tree$1.value();
            Object a2 = tree$1.key();
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            tree2 = new RedBlackTree.RedTree(a2, b2, tree4, tree3);
        }
        return tree2;
    }

    private final RedBlackTree.Tree delRight$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        RedBlackTree.Tree tree2;
        if (this.scala$collection$immutable$RedBlackTree$$isBlackTree(tree$1.right())) {
            tree2 = this.balRight$1(tree$1.key(), tree$1.value(), tree$1.left(), this.del(tree$1.right(), k$1, ordering$1));
        } else {
            RedBlackTree.Tree tree3 = this.del(tree$1.right(), k$1, ordering$1);
            RedBlackTree.Tree tree4 = tree$1.left();
            Object b2 = tree$1.value();
            Object a2 = tree$1.key();
            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
            tree2 = new RedBlackTree.RedTree(a2, b2, tree4, tree3);
        }
        return tree2;
    }

    private final RedBlackTree.Tree append$1(RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        block13: {
            RedBlackTree.Tree tree2;
            block8: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    if (tl != null) break block7;
                                    tree2 = tr;
                                    break block8;
                                }
                                if (tr != null) break block9;
                                tree2 = tl;
                                break block8;
                            }
                            if (!this.isRedTree(tl) || !this.isRedTree(tr)) break block10;
                            RedBlackTree.Tree bc = this.append$1(tl.right(), tr.left());
                            if (this.isRedTree(bc)) {
                                RedBlackTree.Tree tree3 = bc.left();
                                RedBlackTree.Tree tree4 = tl.left();
                                Object b2 = tl.value();
                                Object a2 = tl.key();
                                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                                RedBlackTree.Tree tree5 = tr.right();
                                RedBlackTree.Tree tree6 = bc.right();
                                Object b3 = tr.value();
                                Object a3 = tr.key();
                                RedBlackTree$RedTree$ redBlackTree$RedTree$2 = RedBlackTree$RedTree$.MODULE$;
                                RedBlackTree.RedTree redTree = new RedBlackTree.RedTree(a3, b3, tree6, tree5);
                                RedBlackTree.RedTree redTree2 = new RedBlackTree.RedTree(a2, b2, tree4, tree3);
                                Object b4 = bc.value();
                                Object a4 = bc.key();
                                RedBlackTree$RedTree$ redBlackTree$RedTree$3 = RedBlackTree$RedTree$.MODULE$;
                                tree2 = new RedBlackTree.RedTree(a4, b4, redTree2, redTree);
                            } else {
                                RedBlackTree.Tree tree7 = tr.right();
                                Object b5 = tr.value();
                                Object a5 = tr.key();
                                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                                RedBlackTree.RedTree redTree = new RedBlackTree.RedTree(a5, b5, bc, tree7);
                                RedBlackTree.Tree tree8 = tl.left();
                                Object b6 = tl.value();
                                Object a6 = tl.key();
                                RedBlackTree$RedTree$ redBlackTree$RedTree$4 = RedBlackTree$RedTree$.MODULE$;
                                tree2 = new RedBlackTree.RedTree(a6, b6, tree8, redTree);
                            }
                            break block8;
                        }
                        if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(tl) || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(tr)) break block11;
                        RedBlackTree.Tree bc = this.append$1(tl.right(), tr.left());
                        if (this.isRedTree(bc)) {
                            RedBlackTree.Tree tree9 = bc.left();
                            RedBlackTree.Tree tree10 = tl.left();
                            Object b7 = tl.value();
                            Object a7 = tl.key();
                            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                            RedBlackTree.Tree tree11 = tr.right();
                            RedBlackTree.Tree tree12 = bc.right();
                            Object b8 = tr.value();
                            Object a8 = tr.key();
                            RedBlackTree$BlackTree$ redBlackTree$BlackTree$2 = RedBlackTree$BlackTree$.MODULE$;
                            RedBlackTree.BlackTree blackTree = new RedBlackTree.BlackTree(a8, b8, tree12, tree11);
                            RedBlackTree.BlackTree blackTree2 = new RedBlackTree.BlackTree(a7, b7, tree10, tree9);
                            Object b9 = bc.value();
                            Object a9 = bc.key();
                            RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                            tree2 = new RedBlackTree.RedTree(a9, b9, blackTree2, blackTree);
                        } else {
                            RedBlackTree.Tree tree13 = tr.right();
                            Object b10 = tr.value();
                            Object a10 = tr.key();
                            RedBlackTree$BlackTree$ redBlackTree$BlackTree$ = RedBlackTree$BlackTree$.MODULE$;
                            tree2 = this.balLeft$1(tl.key(), tl.value(), tl.left(), new RedBlackTree.BlackTree(a10, b10, bc, tree13));
                        }
                        break block8;
                    }
                    if (!this.isRedTree(tr)) break block12;
                    RedBlackTree.Tree tree14 = tr.right();
                    RedBlackTree.Tree tree15 = this.append$1(tl, tr.left());
                    Object b11 = tr.value();
                    Object a11 = tr.key();
                    RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                    tree2 = new RedBlackTree.RedTree(a11, b11, tree15, tree14);
                    break block8;
                }
                if (!this.isRedTree(tl)) break block13;
                RedBlackTree.Tree tree16 = this.append$1(tl.right(), tr);
                RedBlackTree.Tree tree17 = tl.left();
                Object b12 = tl.value();
                Object a12 = tl.key();
                RedBlackTree$RedTree$ redBlackTree$RedTree$ = RedBlackTree$RedTree$.MODULE$;
                tree2 = new RedBlackTree.RedTree(a12, b12, tree17, tree16);
            }
            return tree2;
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"unmatched tree on append: ").append(tl).append((Object)", ").append(tr).toString());
    }

    private final RedBlackTree.NList unzip$1(RedBlackTree.NList zipper, boolean leftMost) {
        while (true) {
            RedBlackTree.Tree next2;
            RedBlackTree.Tree tree2 = next2 = leftMost ? ((RedBlackTree.Tree)zipper.head()).left() : ((RedBlackTree.Tree)zipper.head()).right();
            if (next2 == null) {
                return zipper;
            }
            zipper = RedBlackTree$NList$.MODULE$.cons(next2, zipper);
        }
    }

    private final Tuple4 unzipBoth$1(RedBlackTree.Tree left2, RedBlackTree.Tree right2, RedBlackTree.NList leftZipper, RedBlackTree.NList rightZipper, int smallerDepth) {
        block10: {
            Tuple4<Object, Boolean, Boolean, Integer> tuple42;
            block8: {
                block9: {
                    block7: {
                        while (true) {
                            if (this.scala$collection$immutable$RedBlackTree$$isBlackTree(left2) && this.scala$collection$immutable$RedBlackTree$$isBlackTree(right2)) {
                                ++smallerDepth;
                                rightZipper = RedBlackTree$NList$.MODULE$.cons(right2, rightZipper);
                                leftZipper = RedBlackTree$NList$.MODULE$.cons(left2, leftZipper);
                                right2 = right2.left();
                                left2 = left2.right();
                                continue;
                            }
                            if (this.isRedTree(left2) && this.isRedTree(right2)) {
                                rightZipper = RedBlackTree$NList$.MODULE$.cons(right2, rightZipper);
                                leftZipper = RedBlackTree$NList$.MODULE$.cons(left2, leftZipper);
                                right2 = right2.left();
                                left2 = left2.right();
                                continue;
                            }
                            if (this.isRedTree(right2)) {
                                rightZipper = RedBlackTree$NList$.MODULE$.cons(right2, rightZipper);
                                right2 = right2.left();
                                continue;
                            }
                            if (!this.isRedTree(left2)) break;
                            leftZipper = RedBlackTree$NList$.MODULE$.cons(left2, leftZipper);
                            left2 = left2.right();
                        }
                        if (left2 != null || right2 != null) break block7;
                        tuple42 = new Tuple4<Object, Boolean, Boolean, Integer>(null, BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(smallerDepth));
                        break block8;
                    }
                    if (left2 != null || !this.scala$collection$immutable$RedBlackTree$$isBlackTree(right2)) break block9;
                    tuple42 = new Tuple4<RedBlackTree.NList, Boolean, Boolean, Integer>(this.unzip$1(RedBlackTree$NList$.MODULE$.cons(right2, rightZipper), true), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToInteger(smallerDepth));
                    break block8;
                }
                if (!this.scala$collection$immutable$RedBlackTree$$isBlackTree(left2) || right2 != null) break block10;
                tuple42 = new Tuple4<RedBlackTree.NList, Boolean, Boolean, Integer>(this.unzip$1(RedBlackTree$NList$.MODULE$.cons(left2, leftZipper), false), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(smallerDepth));
            }
            return tuple42;
        }
        throw package$.MODULE$.error(new StringBuilder().append((Object)"unmatched trees in unzip: ").append(left2).append((Object)", ").append(right2).toString());
    }

    private final RedBlackTree.NList findDepth$1(RedBlackTree.NList zipper, int depth) {
        while (true) {
            if (zipper == null) {
                throw package$.MODULE$.error("Defect: unexpected empty zipper while computing range");
            }
            if (this.scala$collection$immutable$RedBlackTree$$isBlackTree((RedBlackTree.Tree)zipper.head())) {
                if (depth == 1) {
                    return zipper;
                }
                --depth;
                zipper = zipper.tail();
                continue;
            }
            zipper = zipper.tail();
        }
    }

    private RedBlackTree$() {
        MODULE$ = this;
    }
}

