/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.oauth.org.apache.commons.codec.net;

import java.io.UnsupportedEncodingException;
import play.shaded.oauth.org.apache.commons.codec.DecoderException;
import play.shaded.oauth.org.apache.commons.codec.EncoderException;

abstract class RFC1522Codec {
    RFC1522Codec() {
    }

    protected String encodeText(String text2, String charset) throws EncoderException, UnsupportedEncodingException {
        if (text2 == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("=?");
        buffer.append(charset);
        buffer.append('?');
        buffer.append(this.getEncoding());
        buffer.append('?');
        byte[] rawdata = this.doEncoding(text2.getBytes(charset));
        buffer.append(new String(rawdata, "US-ASCII"));
        buffer.append("?=");
        return buffer.toString();
    }

    protected String decodeText(String text2) throws DecoderException, UnsupportedEncodingException {
        if (text2 == null) {
            return null;
        }
        if (!text2.startsWith("=?") || !text2.endsWith("?=")) {
            throw new DecoderException("RFC 1522 violation: malformed encoded content");
        }
        int termnator = text2.length() - 2;
        int from2 = 2;
        int to2 = text2.indexOf("?", from2);
        if (to2 == -1 || to2 == termnator) {
            throw new DecoderException("RFC 1522 violation: charset token not found");
        }
        String charset = text2.substring(from2, to2);
        if (charset.equals("")) {
            throw new DecoderException("RFC 1522 violation: charset not specified");
        }
        from2 = to2 + 1;
        if ((to2 = text2.indexOf("?", from2)) == -1 || to2 == termnator) {
            throw new DecoderException("RFC 1522 violation: encoding token not found");
        }
        String encoding = text2.substring(from2, to2);
        if (!this.getEncoding().equalsIgnoreCase(encoding)) {
            throw new DecoderException("This codec cannot decode " + encoding + " encoded content");
        }
        from2 = to2 + 1;
        to2 = text2.indexOf("?", from2);
        byte[] data = text2.substring(from2, to2).getBytes("US-ASCII");
        data = this.doDecoding(data);
        return new String(data, charset);
    }

    protected abstract String getEncoding();

    protected abstract byte[] doEncoding(byte[] var1) throws EncoderException;

    protected abstract byte[] doDecoding(byte[] var1) throws DecoderException;
}

