/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.oauth.org.apache.commons.codec.binary;

import play.shaded.oauth.org.apache.commons.codec.BinaryDecoder;
import play.shaded.oauth.org.apache.commons.codec.BinaryEncoder;
import play.shaded.oauth.org.apache.commons.codec.DecoderException;
import play.shaded.oauth.org.apache.commons.codec.EncoderException;

public class Hex
implements BinaryEncoder,
BinaryDecoder {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] decodeHex(char[] data) throws DecoderException {
        int len2 = data.length;
        if ((len2 & 1) != 0) {
            throw new DecoderException("Odd number of characters.");
        }
        byte[] out = new byte[len2 >> 1];
        int i = 0;
        int j = 0;
        while (j < len2) {
            int f2 = Hex.toDigit(data[j], j) << 4;
            f2 |= Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f2 & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index2) throws DecoderException {
        int digit2 = Character.digit(ch, 16);
        if (digit2 == -1) {
            throw new DecoderException("Illegal hexadecimal charcter " + ch + " at index " + index2);
        }
        return digit2;
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }

    public byte[] decode(byte[] array2) throws DecoderException {
        return Hex.decodeHex(new String(array2).toCharArray());
    }

    public Object decode(Object object) throws DecoderException {
        try {
            char[] charArray = object instanceof String ? ((String)object).toCharArray() : (char[])object;
            return Hex.decodeHex(charArray);
        }
        catch (ClassCastException e) {
            throw new DecoderException(e.getMessage());
        }
    }

    public byte[] encode(byte[] array2) {
        return new String(Hex.encodeHex(array2)).getBytes();
    }

    public Object encode(Object object) throws EncoderException {
        try {
            byte[] byteArray = object instanceof String ? ((String)object).getBytes() : (byte[])object;
            return Hex.encodeHex(byteArray);
        }
        catch (ClassCastException e) {
            throw new EncoderException(e.getMessage());
        }
    }
}

