/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.oauth.oauth.signpost.signature;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import play.shaded.oauth.oauth.signpost.OAuth;
import play.shaded.oauth.oauth.signpost.exception.OAuthMessageSignerException;
import play.shaded.oauth.oauth.signpost.http.HttpParameters;
import play.shaded.oauth.oauth.signpost.http.HttpRequest;

public class SignatureBaseString {
    private HttpRequest request;
    private HttpParameters requestParameters;

    public SignatureBaseString(HttpRequest request2, HttpParameters requestParameters) {
        this.request = request2;
        this.requestParameters = requestParameters;
    }

    public String generate() throws OAuthMessageSignerException {
        try {
            String normalizedUrl = this.normalizeRequestUrl();
            String normalizedParams = this.normalizeRequestParameters();
            return this.request.getMethod() + '&' + OAuth.percentEncode(normalizedUrl) + '&' + OAuth.percentEncode(normalizedParams);
        }
        catch (Exception e) {
            throw new OAuthMessageSignerException(e);
        }
    }

    public String normalizeRequestUrl() throws URISyntaxException {
        String path2;
        int index2;
        boolean dropPort;
        URI uri = new URI(this.request.getRequestUrl());
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = scheme.equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443;
        if (dropPort && (index2 = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, index2);
        }
        if ((path2 = uri.getRawPath()) == null || path2.length() <= 0) {
            path2 = "/";
        }
        return scheme + "://" + authority + path2;
    }

    public String normalizeRequestParameters() throws IOException {
        if (this.requestParameters == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter2 = this.requestParameters.keySet().iterator();
        int i = 0;
        while (iter2.hasNext()) {
            String param2 = iter2.next();
            if (!"oauth_signature".equals(param2) && !"realm".equals(param2)) {
                if (i > 0) {
                    sb.append("&");
                }
                sb.append(this.requestParameters.getAsQueryString(param2, false));
            }
            ++i;
        }
        return sb.toString();
    }
}

