/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.oauth.oauth.signpost.signature;

import java.util.Iterator;
import play.shaded.oauth.oauth.signpost.OAuth;
import play.shaded.oauth.oauth.signpost.http.HttpParameters;
import play.shaded.oauth.oauth.signpost.http.HttpRequest;
import play.shaded.oauth.oauth.signpost.signature.SigningStrategy;

public class AuthorizationHeaderSigningStrategy
implements SigningStrategy {
    private static final long serialVersionUID = 1L;

    public String writeSignature(String signature2, HttpRequest request2, HttpParameters requestParameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("OAuth ");
        if (requestParameters.containsKey("realm")) {
            sb.append(requestParameters.getAsHeaderElement("realm"));
            sb.append(", ");
        }
        HttpParameters oauthParams = requestParameters.getOAuthParameters();
        oauthParams.put("oauth_signature", signature2, true);
        Iterator<String> iter2 = oauthParams.keySet().iterator();
        while (iter2.hasNext()) {
            String key = iter2.next();
            sb.append(oauthParams.getAsHeaderElement(key));
            if (!iter2.hasNext()) continue;
            sb.append(", ");
        }
        String header2 = sb.toString();
        OAuth.debugOut("Auth Header", header2);
        request2.setHeader("Authorization", header2);
        return header2;
    }
}

