/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.oauth.oauth.signpost;

import com.google.gdata.util.common.base.PercentEscaper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import play.shaded.oauth.oauth.signpost.http.HttpParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth {
    public static final String VERSION_1_0 = "1.0";
    public static final String ENCODING = "UTF-8";
    public static final String FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String HTTP_AUTHORIZATION_HEADER = "Authorization";
    public static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String OAUTH_TOKEN_SECRET = "oauth_token_secret";
    public static final String OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    public static final String OAUTH_SIGNATURE = "oauth_signature";
    public static final String OAUTH_TIMESTAMP = "oauth_timestamp";
    public static final String OAUTH_NONCE = "oauth_nonce";
    public static final String OAUTH_VERSION = "oauth_version";
    public static final String OAUTH_CALLBACK = "oauth_callback";
    public static final String OAUTH_CALLBACK_CONFIRMED = "oauth_callback_confirmed";
    public static final String OAUTH_VERIFIER = "oauth_verifier";
    public static final String OUT_OF_BAND = "oob";
    private static final PercentEscaper percentEncoder = new PercentEscaper("-._~", false);

    public static String percentEncode(String s2) {
        if (s2 == null) {
            return "";
        }
        return percentEncoder.escape(s2);
    }

    public static String percentDecode(String s2) {
        try {
            if (s2 == null) {
                return "";
            }
            return URLDecoder.decode(s2, ENCODING);
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    public static <T extends Map.Entry<String, String>> void formEncode(Collection<T> parameters, OutputStream into) throws IOException {
        if (parameters != null) {
            boolean first2 = true;
            for (Map.Entry entry2 : parameters) {
                if (first2) {
                    first2 = false;
                } else {
                    into.write(38);
                }
                into.write(OAuth.percentEncode(OAuth.safeToString(entry2.getKey())).getBytes());
                into.write(61);
                into.write(OAuth.percentEncode(OAuth.safeToString(entry2.getValue())).getBytes());
            }
        }
    }

    public static <T extends Map.Entry<String, String>> String formEncode(Collection<T> parameters) throws IOException {
        ByteArrayOutputStream b2 = new ByteArrayOutputStream();
        OAuth.formEncode(parameters, b2);
        return new String(b2.toByteArray());
    }

    public static HttpParameters decodeForm(String form) {
        HttpParameters params2 = new HttpParameters();
        if (OAuth.isEmpty(form)) {
            return params2;
        }
        for (String nvp : form.split("\\&")) {
            String value2;
            String name;
            int equals2 = nvp.indexOf(61);
            if (equals2 < 0) {
                name = OAuth.percentDecode(nvp);
                value2 = null;
            } else {
                name = OAuth.percentDecode(nvp.substring(0, equals2));
                value2 = OAuth.percentDecode(nvp.substring(equals2 + 1));
            }
            params2.put(name, value2);
        }
        return params2;
    }

    public static HttpParameters decodeForm(InputStream content) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(content));
        StringBuilder sb = new StringBuilder();
        String line2 = reader.readLine();
        while (line2 != null) {
            sb.append(line2);
            line2 = reader.readLine();
        }
        return OAuth.decodeForm(sb.toString());
    }

    public static <T extends Map.Entry<String, String>> Map<String, String> toMap(Collection<T> from2) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        if (from2 != null) {
            for (Map.Entry entry2 : from2) {
                String key = (String)entry2.getKey();
                if (map2.containsKey(key)) continue;
                map2.put(key, (String)entry2.getValue());
            }
        }
        return map2;
    }

    public static final String safeToString(Object from2) {
        return from2 == null ? null : from2.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String addQueryParameters(String url, String ... kvPairs) {
        String queryDelim = url.contains("?") ? "&" : "?";
        StringBuilder sb = new StringBuilder(url + queryDelim);
        for (int i = 0; i < kvPairs.length; i += 2) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append(OAuth.percentEncode(kvPairs[i]) + "=" + OAuth.percentEncode(kvPairs[i + 1]));
        }
        return sb.toString();
    }

    public static String addQueryParameters(String url, Map<String, String> params2) {
        String[] kvPairs = new String[params2.size() * 2];
        int idx = 0;
        Iterator<String> i$ = params2.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            kvPairs[idx] = key = i$.next();
            kvPairs[idx + 1] = params2.get(key);
            idx += 2;
        }
        return OAuth.addQueryParameters(url, kvPairs);
    }

    public static String addQueryString(String url, String queryString) {
        String queryDelim = url.contains("?") ? "&" : "?";
        StringBuilder sb = new StringBuilder(url + queryDelim);
        sb.append(queryString);
        return sb.toString();
    }

    public static String prepareOAuthHeader(String ... kvPairs) {
        StringBuilder sb = new StringBuilder("OAuth ");
        for (int i = 0; i < kvPairs.length; i += 2) {
            if (i > 0) {
                sb.append(", ");
            }
            boolean isOAuthElem = kvPairs[i].startsWith("oauth_") || kvPairs[i].startsWith("x_oauth_");
            String value2 = isOAuthElem ? OAuth.percentEncode(kvPairs[i + 1]) : kvPairs[i + 1];
            sb.append(OAuth.percentEncode(kvPairs[i]) + "=\"" + value2 + "\"");
        }
        return sb.toString();
    }

    public static HttpParameters oauthHeaderToParamsMap(String oauthHeader) {
        String[] elements2;
        HttpParameters params2 = new HttpParameters();
        if (oauthHeader == null || !oauthHeader.startsWith("OAuth ")) {
            return params2;
        }
        oauthHeader = oauthHeader.substring("OAuth ".length());
        for (String keyValuePair : elements2 = oauthHeader.split(",")) {
            String[] keyValue = keyValuePair.split("=");
            params2.put(keyValue[0].trim(), keyValue[1].replace("\"", "").trim());
        }
        return params2;
    }

    public static String toHeaderElement(String name, String value2) {
        return OAuth.percentEncode(name) + "=\"" + OAuth.percentEncode(value2) + "\"";
    }

    public static void debugOut(String key, String value2) {
        if (System.getProperty("debug") != null) {
            System.out.println("[SIGNPOST] " + key + ": " + value2);
        }
    }
}

