/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.oauth.oauth.signpost;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import play.shaded.oauth.oauth.signpost.OAuth;
import play.shaded.oauth.oauth.signpost.OAuthConsumer;
import play.shaded.oauth.oauth.signpost.OAuthProvider;
import play.shaded.oauth.oauth.signpost.OAuthProviderListener;
import play.shaded.oauth.oauth.signpost.exception.OAuthCommunicationException;
import play.shaded.oauth.oauth.signpost.exception.OAuthExpectationFailedException;
import play.shaded.oauth.oauth.signpost.exception.OAuthMessageSignerException;
import play.shaded.oauth.oauth.signpost.exception.OAuthNotAuthorizedException;
import play.shaded.oauth.oauth.signpost.http.HttpParameters;
import play.shaded.oauth.oauth.signpost.http.HttpRequest;
import play.shaded.oauth.oauth.signpost.http.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOAuthProvider
implements OAuthProvider {
    private static final long serialVersionUID = 1L;
    private String requestTokenEndpointUrl;
    private String accessTokenEndpointUrl;
    private String authorizationWebsiteUrl;
    private HttpParameters responseParameters;
    private Map<String, String> defaultHeaders;
    private boolean isOAuth10a;
    private transient OAuthProviderListener listener;

    public AbstractOAuthProvider(String requestTokenEndpointUrl, String accessTokenEndpointUrl, String authorizationWebsiteUrl) {
        this.requestTokenEndpointUrl = requestTokenEndpointUrl;
        this.accessTokenEndpointUrl = accessTokenEndpointUrl;
        this.authorizationWebsiteUrl = authorizationWebsiteUrl;
        this.responseParameters = new HttpParameters();
        this.defaultHeaders = new HashMap<String, String>();
    }

    @Override
    public synchronized String retrieveRequestToken(OAuthConsumer consumer, String callbackUrl, String ... customOAuthParams) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        consumer.setTokenWithSecret(null, null);
        HttpParameters params2 = new HttpParameters();
        params2.putAll(customOAuthParams, true);
        params2.put("oauth_callback", callbackUrl, true);
        this.retrieveToken(consumer, this.requestTokenEndpointUrl, params2);
        String callbackConfirmed = this.responseParameters.getFirst("oauth_callback_confirmed");
        this.responseParameters.remove("oauth_callback_confirmed");
        this.isOAuth10a = Boolean.TRUE.toString().equals(callbackConfirmed);
        if (this.isOAuth10a) {
            return OAuth.addQueryParameters(this.authorizationWebsiteUrl, "oauth_token", consumer.getToken());
        }
        return OAuth.addQueryParameters(this.authorizationWebsiteUrl, "oauth_token", consumer.getToken(), "oauth_callback", callbackUrl);
    }

    @Override
    public synchronized void retrieveAccessToken(OAuthConsumer consumer, String oauthVerifier, String ... customOAuthParams) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        if (consumer.getToken() == null || consumer.getTokenSecret() == null) {
            throw new OAuthExpectationFailedException("Authorized request token or token secret not set. Did you retrieve an authorized request token before?");
        }
        HttpParameters params2 = new HttpParameters();
        params2.putAll(customOAuthParams, true);
        if (this.isOAuth10a && oauthVerifier != null) {
            params2.put("oauth_verifier", oauthVerifier, true);
        }
        this.retrieveToken(consumer, this.accessTokenEndpointUrl, params2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void retrieveToken(OAuthConsumer consumer, String endpointUrl, HttpParameters customOAuthParams) throws OAuthMessageSignerException, OAuthCommunicationException, OAuthNotAuthorizedException, OAuthExpectationFailedException {
        int statusCode;
        HttpResponse response;
        HttpRequest request2;
        block21: {
            Map<String, String> defaultHeaders = this.getRequestHeaders();
            if (consumer.getConsumerKey() == null) throw new OAuthExpectationFailedException("Consumer key or secret not set");
            if (consumer.getConsumerSecret() == null) {
                throw new OAuthExpectationFailedException("Consumer key or secret not set");
            }
            request2 = null;
            response = null;
            request2 = this.createRequest(endpointUrl);
            for (String header2 : defaultHeaders.keySet()) {
                request2.setHeader(header2, defaultHeaders.get(header2));
            }
            if (customOAuthParams != null && !customOAuthParams.isEmpty()) {
                consumer.setAdditionalParameters(customOAuthParams);
            }
            if (this.listener != null) {
                this.listener.prepareRequest(request2);
            }
            consumer.sign(request2);
            if (this.listener != null) {
                this.listener.prepareSubmission(request2);
            }
            response = this.sendRequest(request2);
            statusCode = response.getStatusCode();
            boolean requestHandled = false;
            if (this.listener != null) {
                requestHandled = this.listener.onResponseReceived(request2, response);
            }
            if (!requestHandled) break block21;
            try {
                this.closeConnection(request2, response);
                return;
            }
            catch (Exception e) {
                throw new OAuthCommunicationException(e);
            }
        }
        if (statusCode >= 300) {
            this.handleUnexpectedResponse(statusCode, response);
        }
        HttpParameters responseParams = OAuth.decodeForm(response.getContent());
        String token2 = responseParams.getFirst("oauth_token");
        String secret = responseParams.getFirst("oauth_token_secret");
        responseParams.remove("oauth_token");
        responseParams.remove("oauth_token_secret");
        this.setResponseParameters(responseParams);
        if (token2 == null) throw new OAuthExpectationFailedException("Request token or token secret not set in server reply. The service provider you use is probably buggy.");
        if (secret == null) {
            throw new OAuthExpectationFailedException("Request token or token secret not set in server reply. The service provider you use is probably buggy.");
        }
        consumer.setTokenWithSecret(token2, secret);
        try {
            this.closeConnection(request2, response);
            return;
        }
        catch (Exception e) {
            throw new OAuthCommunicationException(e);
        }
        catch (OAuthNotAuthorizedException e) {
            try {
                throw e;
                catch (OAuthExpectationFailedException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new OAuthCommunicationException(e3);
                }
            }
            catch (Throwable throwable2) {
                try {
                    this.closeConnection(request2, response);
                    throw throwable2;
                }
                catch (Exception e4) {
                    throw new OAuthCommunicationException(e4);
                }
            }
        }
    }

    protected void handleUnexpectedResponse(int statusCode, HttpResponse response) throws Exception {
        if (response == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getContent()));
        StringBuilder responseBody = new StringBuilder();
        String line2 = reader.readLine();
        while (line2 != null) {
            responseBody.append(line2);
            line2 = reader.readLine();
        }
        switch (statusCode) {
            case 401: {
                throw new OAuthNotAuthorizedException(responseBody.toString());
            }
        }
        throw new OAuthCommunicationException("Service provider responded in error: " + statusCode + " (" + response.getReasonPhrase() + ")", responseBody.toString());
    }

    protected abstract HttpRequest createRequest(String var1) throws Exception;

    protected abstract HttpResponse sendRequest(HttpRequest var1) throws Exception;

    protected void closeConnection(HttpRequest request2, HttpResponse response) throws Exception {
    }

    @Override
    public HttpParameters getResponseParameters() {
        return this.responseParameters;
    }

    protected String getResponseParameter(String key) {
        return this.responseParameters.getFirst(key);
    }

    @Override
    public void setResponseParameters(HttpParameters parameters) {
        this.responseParameters = parameters;
    }

    @Override
    public void setOAuth10a(boolean isOAuth10aProvider) {
        this.isOAuth10a = isOAuth10aProvider;
    }

    @Override
    public boolean isOAuth10a() {
        return this.isOAuth10a;
    }

    @Override
    public String getRequestTokenEndpointUrl() {
        return this.requestTokenEndpointUrl;
    }

    @Override
    public String getAccessTokenEndpointUrl() {
        return this.accessTokenEndpointUrl;
    }

    @Override
    public String getAuthorizationWebsiteUrl() {
        return this.authorizationWebsiteUrl;
    }

    @Override
    public void setRequestHeader(String header2, String value2) {
        this.defaultHeaders.put(header2, value2);
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.defaultHeaders;
    }

    @Override
    public void setListener(OAuthProviderListener listener) {
        this.listener = listener;
    }

    @Override
    public void removeListener(OAuthProviderListener listener) {
        this.listener = null;
    }
}

