/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.util;

import java.util.List;
import play.shaded.ahc.org.asynchttpclient.Param;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import play.shaded.ahc.org.asynchttpclient.util.StringBuilderPool;
import play.shaded.ahc.org.asynchttpclient.util.Utf8UrlEncoder;

public enum UriEncoder {
    FIXING{

        @Override
        public String encodePath(String path2) {
            return Utf8UrlEncoder.encodePath(path2);
        }

        private void encodeAndAppendQueryParam(StringBuilder sb, CharSequence name, CharSequence value2) {
            Utf8UrlEncoder.encodeAndAppendQueryElement(sb, name);
            if (value2 != null) {
                sb.append('=');
                Utf8UrlEncoder.encodeAndAppendQueryElement(sb, value2);
            }
            sb.append('&');
        }

        private void encodeAndAppendQueryParams(StringBuilder sb, List<Param> queryParams) {
            for (Param param2 : queryParams) {
                this.encodeAndAppendQueryParam(sb, param2.getName(), param2.getValue());
            }
        }

        @Override
        protected String withQueryWithParams(String query, List<Param> queryParams) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
            Utf8UrlEncoder.encodeAndAppendQuery(sb, query);
            sb.append('&');
            this.encodeAndAppendQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        @Override
        protected String withQueryWithoutParams(String query) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
            Utf8UrlEncoder.encodeAndAppendQuery(sb, query);
            return sb.toString();
        }

        @Override
        protected String withoutQueryWithParams(List<Param> queryParams) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
            this.encodeAndAppendQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
    }
    ,
    RAW{

        @Override
        public String encodePath(String path2) {
            return path2;
        }

        private void appendRawQueryParam(StringBuilder sb, String name, String value2) {
            sb.append(name);
            if (value2 != null) {
                sb.append('=').append(value2);
            }
            sb.append('&');
        }

        private void appendRawQueryParams(StringBuilder sb, List<Param> queryParams) {
            for (Param param2 : queryParams) {
                this.appendRawQueryParam(sb, param2.getName(), param2.getValue());
            }
        }

        @Override
        protected String withQueryWithParams(String query, List<Param> queryParams) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
            sb.append(query);
            this.appendRawQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        @Override
        protected String withQueryWithoutParams(String query) {
            return query;
        }

        @Override
        protected String withoutQueryWithParams(List<Param> queryParams) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
            this.appendRawQueryParams(sb, queryParams);
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
    };


    public static UriEncoder uriEncoder(boolean disableUrlEncoding) {
        return disableUrlEncoding ? RAW : FIXING;
    }

    protected abstract String withQueryWithParams(String var1, List<Param> var2);

    protected abstract String withQueryWithoutParams(String var1);

    protected abstract String withoutQueryWithParams(List<Param> var1);

    private String withQuery(String query, List<Param> queryParams) {
        return MiscUtils.isNonEmpty(queryParams) ? this.withQueryWithParams(query, queryParams) : this.withQueryWithoutParams(query);
    }

    private String withoutQuery(List<Param> queryParams) {
        return MiscUtils.isNonEmpty(queryParams) ? this.withoutQueryWithParams(queryParams) : null;
    }

    public Uri encode(Uri uri, List<Param> queryParams) {
        String newPath = this.encodePath(uri.getPath());
        String newQuery = this.encodeQuery(uri.getQuery(), queryParams);
        return new Uri(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), newPath, newQuery, uri.getFragment());
    }

    protected abstract String encodePath(String var1);

    private String encodeQuery(String query, List<Param> queryParams) {
        return MiscUtils.isNonEmpty(query) ? this.withQuery(query, queryParams) : this.withoutQuery(queryParams);
    }
}

