/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderValues;
import play.shaded.ahc.io.netty.util.AsciiString;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.Param;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;
import play.shaded.ahc.org.asynchttpclient.util.StringBuilderPool;
import play.shaded.ahc.org.asynchttpclient.util.StringUtils;
import play.shaded.ahc.org.asynchttpclient.util.Utf8UrlEncoder;

public class HttpUtils {
    public static final AsciiString ACCEPT_ALL_HEADER_VALUE = new AsciiString("*/*");
    public static final AsciiString GZIP_DEFLATE = new AsciiString(HttpHeaderValues.GZIP + "," + HttpHeaderValues.DEFLATE);
    private static final String CONTENT_TYPE_CHARSET_ATTRIBUTE = "charset=";
    private static final String CONTENT_TYPE_BOUNDARY_ATTRIBUTE = "boundary=";
    private static final String BROTLY_ACCEPT_ENCODING_SUFFIX = ", br";
    private static byte[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(StandardCharsets.US_ASCII);

    private HttpUtils() {
    }

    public static String hostHeader(Uri uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        return port == -1 || port == uri.getSchemeDefaultPort() ? host : host + ":" + port;
    }

    public static String originHeader(Uri uri) {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        sb.append(uri.isSecured() ? "https://" : "http://").append(uri.getHost());
        if (uri.getExplicitPort() != uri.getSchemeDefaultPort()) {
            sb.append(':').append(uri.getPort());
        }
        return sb.toString();
    }

    public static Charset extractContentTypeCharsetAttribute(String contentType2) {
        String charsetName = HttpUtils.extractContentTypeAttribute(contentType2, CONTENT_TYPE_CHARSET_ATTRIBUTE);
        return charsetName != null ? Charset.forName(charsetName) : null;
    }

    public static String extractContentTypeBoundaryAttribute(String contentType2) {
        return HttpUtils.extractContentTypeAttribute(contentType2, CONTENT_TYPE_BOUNDARY_ATTRIBUTE);
    }

    private static String extractContentTypeAttribute(String contentType2, String attribute2) {
        if (contentType2 == null) {
            return null;
        }
        for (int i = 0; i < contentType2.length(); ++i) {
            char c;
            int end;
            char c2;
            int start2;
            if (!contentType2.regionMatches(true, i, attribute2, 0, attribute2.length())) continue;
            for (start2 = i + attribute2.length(); start2 < contentType2.length() && ((c2 = contentType2.charAt(start2)) == ' ' || c2 == '\'' || c2 == '\"'); ++start2) {
            }
            if (start2 == contentType2.length()) break;
            for (end = start2 + 1; end < contentType2.length() && (c = contentType2.charAt(end)) != ' ' && c != '\'' && c != '\"' && c != ';'; ++end) {
            }
            return contentType2.substring(start2, end);
        }
        return null;
    }

    public static byte[] computeMultipartBoundary() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] bytes2 = new byte[random.nextInt(11) + 30];
        for (int i = 0; i < bytes2.length; ++i) {
            bytes2[i] = MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)];
        }
        return bytes2;
    }

    public static String patchContentTypeWithBoundaryAttribute(CharSequence base, byte[] boundary) {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder().append(base);
        if (base.length() != 0 && base.charAt(base.length() - 1) != ';') {
            sb.append(';');
        }
        return sb.append(' ').append(CONTENT_TYPE_BOUNDARY_ATTRIBUTE).append(new String(boundary, StandardCharsets.US_ASCII)).toString();
    }

    public static boolean followRedirect(AsyncHttpClientConfig config, Request request2) {
        return request2.getFollowRedirect() != null ? request2.getFollowRedirect().booleanValue() : config.isFollowRedirect();
    }

    public static ByteBuffer urlEncodeFormParams(List<Param> params2, Charset charset) {
        return StringUtils.charSequence2ByteBuffer(HttpUtils.urlEncodeFormParams0(params2, charset), StandardCharsets.US_ASCII);
    }

    private static StringBuilder urlEncodeFormParams0(List<Param> params2, Charset charset) {
        StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder();
        for (Param param2 : params2) {
            HttpUtils.encodeAndAppendFormParam(sb, param2.getName(), param2.getValue(), charset);
        }
        sb.setLength(sb.length() - 1);
        return sb;
    }

    private static void encodeAndAppendFormParam(StringBuilder sb, String name, String value2, Charset charset) {
        HttpUtils.encodeAndAppendFormField(sb, name, charset);
        if (value2 != null) {
            sb.append('=');
            HttpUtils.encodeAndAppendFormField(sb, value2, charset);
        }
        sb.append('&');
    }

    private static void encodeAndAppendFormField(StringBuilder sb, String field2, Charset charset) {
        if (charset.equals(StandardCharsets.UTF_8)) {
            Utf8UrlEncoder.encodeAndAppendFormElement(sb, field2);
        } else {
            try {
                sb.append(URLEncoder.encode(field2, charset.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public static CharSequence filterOutBrotliFromAcceptEncoding(String acceptEncoding) {
        if (acceptEncoding.endsWith(BROTLY_ACCEPT_ENCODING_SUFFIX)) {
            return acceptEncoding.subSequence(0, acceptEncoding.length() - BROTLY_ACCEPT_ENCODING_SUFFIX.length());
        }
        return acceptEncoding;
    }
}

