/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.org.asynchttpclient.Dsl;
import play.shaded.ahc.org.asynchttpclient.Realm;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.ntlm.NtlmEngine;
import play.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import play.shaded.ahc.org.asynchttpclient.spnego.SpnegoEngine;
import play.shaded.ahc.org.asynchttpclient.spnego.SpnegoEngineException;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;
import play.shaded.ahc.org.asynchttpclient.util.StringUtils;

public final class AuthenticatorUtils {
    public static final String NEGOTIATE = "Negotiate";

    public static String getHeaderWithPrefix(List<String> authenticateHeaders, String prefix) {
        if (authenticateHeaders != null) {
            for (String authenticateHeader : authenticateHeaders) {
                if (!authenticateHeader.regionMatches(true, 0, prefix, 0, prefix.length())) continue;
                return authenticateHeader;
            }
        }
        return null;
    }

    private static String computeBasicAuthentication(Realm realm) {
        return realm != null ? AuthenticatorUtils.computeBasicAuthentication(realm.getPrincipal(), realm.getPassword(), realm.getCharset()) : null;
    }

    private static String computeBasicAuthentication(String principal, String password, Charset charset) {
        String s2 = principal + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(s2.getBytes(charset));
    }

    public static String computeRealmURI(Uri uri, boolean useAbsoluteURI, boolean omitQuery) {
        if (useAbsoluteURI) {
            return omitQuery && MiscUtils.isNonEmpty(uri.getQuery()) ? uri.withNewQuery(null).toUrl() : uri.toUrl();
        }
        String path2 = uri.getNonEmptyPath();
        return omitQuery || !MiscUtils.isNonEmpty(uri.getQuery()) ? path2 : path2 + "?" + uri.getQuery();
    }

    private static String computeDigestAuthentication(Realm realm) {
        String realmUri = AuthenticatorUtils.computeRealmURI(realm.getUri(), realm.isUseAbsoluteURI(), realm.isOmitQuery());
        StringBuilder builder = new StringBuilder().append("Digest ");
        AuthenticatorUtils.append(builder, "username", realm.getPrincipal(), true);
        AuthenticatorUtils.append(builder, "realm", realm.getRealmName(), true);
        AuthenticatorUtils.append(builder, "nonce", realm.getNonce(), true);
        AuthenticatorUtils.append(builder, "uri", realmUri, true);
        if (MiscUtils.isNonEmpty(realm.getAlgorithm())) {
            AuthenticatorUtils.append(builder, "algorithm", realm.getAlgorithm(), false);
        }
        AuthenticatorUtils.append(builder, "response", realm.getResponse(), true);
        if (realm.getOpaque() != null) {
            AuthenticatorUtils.append(builder, "opaque", realm.getOpaque(), true);
        }
        if (realm.getQop() != null) {
            AuthenticatorUtils.append(builder, "qop", realm.getQop(), false);
            AuthenticatorUtils.append(builder, "nc", realm.getNc(), false);
            AuthenticatorUtils.append(builder, "cnonce", realm.getCnonce(), true);
        }
        builder.setLength(builder.length() - 2);
        return new String(StringUtils.charSequence2Bytes(builder, StandardCharsets.ISO_8859_1));
    }

    private static void append(StringBuilder builder, String name, String value2, boolean quoted2) {
        builder.append(name).append('=');
        if (quoted2) {
            builder.append('\"').append(value2).append('\"');
        } else {
            builder.append(value2);
        }
        builder.append(", ");
    }

    public static String perConnectionProxyAuthorizationHeader(Request request2, Realm proxyRealm) {
        String proxyAuthorization = null;
        if (proxyRealm != null && proxyRealm.isUsePreemptiveAuth()) {
            switch (proxyRealm.getScheme()) {
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    List<String> auth = request2.getHeaders().getAll(HttpHeaderNames.PROXY_AUTHORIZATION);
                    if (AuthenticatorUtils.getHeaderWithPrefix(auth, "NTLM") != null) break;
                    String msg = NtlmEngine.INSTANCE.generateType1Msg();
                    proxyAuthorization = "NTLM " + msg;
                    break;
                }
            }
        }
        return proxyAuthorization;
    }

    public static String perRequestProxyAuthorizationHeader(Request request2, Realm proxyRealm) {
        String proxyAuthorization = null;
        if (proxyRealm != null && proxyRealm.isUsePreemptiveAuth()) {
            switch (proxyRealm.getScheme()) {
                case BASIC: {
                    proxyAuthorization = AuthenticatorUtils.computeBasicAuthentication(proxyRealm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(proxyRealm.getNonce())) break;
                    proxyRealm = Dsl.realm(proxyRealm).setUri(request2.getUri()).setMethodName(request2.getMethod()).build();
                    proxyAuthorization = AuthenticatorUtils.computeDigestAuthentication(proxyRealm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication scheme " + (Object)((Object)proxyRealm.getScheme()));
                }
            }
        }
        return proxyAuthorization;
    }

    public static String perConnectionAuthorizationHeader(Request request2, ProxyServer proxyServer, Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.isUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case NTLM: {
                    String msg = NtlmEngine.INSTANCE.generateType1Msg();
                    authorizationHeader = "NTLM " + msg;
                    break;
                }
                case KERBEROS: 
                case SPNEGO: {
                    String host = proxyServer != null ? proxyServer.getHost() : (request2.getVirtualHost() != null ? request2.getVirtualHost() : request2.getUri().getHost());
                    try {
                        authorizationHeader = "Negotiate " + SpnegoEngine.instance(realm.getPrincipal(), realm.getPassword(), realm.getServicePrincipalName(), realm.getRealmName(), realm.isUseCanonicalHostname(), realm.getCustomLoginConfig(), realm.getLoginContextName()).generateToken(host);
                        break;
                    }
                    catch (SpnegoEngineException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return authorizationHeader;
    }

    public static String perRequestAuthorizationHeader(Request request2, Realm realm) {
        String authorizationHeader = null;
        if (realm != null && realm.isUsePreemptiveAuth()) {
            switch (realm.getScheme()) {
                case BASIC: {
                    authorizationHeader = AuthenticatorUtils.computeBasicAuthentication(realm);
                    break;
                }
                case DIGEST: {
                    if (!MiscUtils.isNonEmpty(realm.getNonce())) break;
                    realm = Dsl.realm(realm).setUri(request2.getUri()).setMethodName(request2.getMethod()).build();
                    authorizationHeader = AuthenticatorUtils.computeDigestAuthentication(realm);
                    break;
                }
                case NTLM: 
                case KERBEROS: 
                case SPNEGO: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid Authentication " + realm);
                }
            }
        }
        return authorizationHeader;
    }
}

