/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.resolver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.shaded.ahc.io.netty.resolver.NameResolver;
import play.shaded.ahc.io.netty.util.concurrent.Future;
import play.shaded.ahc.io.netty.util.concurrent.GenericFutureListener;
import play.shaded.ahc.io.netty.util.concurrent.ImmediateEventExecutor;
import play.shaded.ahc.io.netty.util.concurrent.Promise;
import play.shaded.ahc.org.asynchttpclient.AsyncHandler;
import play.shaded.ahc.org.asynchttpclient.netty.SimpleFutureListener;

public enum RequestHostnameResolver {
    INSTANCE;

    private static final Logger LOGGER;

    public Future<List<InetSocketAddress>> resolve(NameResolver<InetAddress> nameResolver, InetSocketAddress unresolvedAddress, final AsyncHandler<?> asyncHandler) {
        final String hostname = unresolvedAddress.getHostName();
        final int port = unresolvedAddress.getPort();
        final Promise<List<InetSocketAddress>> promise = ImmediateEventExecutor.INSTANCE.newPromise();
        try {
            asyncHandler.onHostnameResolutionAttempt(hostname);
        }
        catch (Exception e) {
            LOGGER.error("onHostnameResolutionAttempt crashed", e);
            promise.tryFailure(e);
            return promise;
        }
        Future<List<InetAddress>> whenResolved = nameResolver.resolveAll(hostname);
        whenResolved.addListener((GenericFutureListener<Future<List<InetAddress>>>)new SimpleFutureListener<List<InetAddress>>(){

            @Override
            protected void onSuccess(List<InetAddress> value2) {
                ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>(value2.size());
                for (InetAddress a2 : value2) {
                    socketAddresses.add(new InetSocketAddress(a2, port));
                }
                try {
                    asyncHandler.onHostnameResolutionSuccess(hostname, socketAddresses);
                }
                catch (Exception e) {
                    LOGGER.error("onHostnameResolutionSuccess crashed", e);
                    promise.tryFailure(e);
                    return;
                }
                promise.trySuccess(socketAddresses);
            }

            @Override
            protected void onFailure(Throwable t) {
                try {
                    asyncHandler.onHostnameResolutionFailure(hostname, t);
                }
                catch (Exception e) {
                    LOGGER.error("onHostnameResolutionFailure crashed", e);
                    promise.tryFailure(e);
                    return;
                }
                promise.tryFailure(t);
            }
        });
        return promise;
    }

    static {
        LOGGER = LoggerFactory.getLogger(RequestHostnameResolver.class);
    }
}

