/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.request.body.multipart.part;

import play.shaded.ahc.io.netty.buffer.ByteBuf;

public interface PartVisitor {
    public void withBytes(byte[] var1);

    public void withByte(byte var1);

    public static class ByteBufVisitor
    implements PartVisitor {
        private final ByteBuf target;

        public ByteBufVisitor(ByteBuf target) {
            this.target = target;
        }

        @Override
        public void withBytes(byte[] bytes2) {
            this.target.writeBytes(bytes2);
        }

        @Override
        public void withByte(byte b2) {
            this.target.writeByte(b2);
        }
    }

    public static class CounterPartVisitor
    implements PartVisitor {
        private int count = 0;

        @Override
        public void withBytes(byte[] bytes2) {
            this.count += bytes2.length;
        }

        @Override
        public void withByte(byte b2) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

