/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.request.body.multipart;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderNames;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaderValues;
import play.shaded.ahc.io.netty.handler.codec.http.HttpHeaders;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.ByteArrayPart;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.FilePart;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.InputStreamPart;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.MultipartBody;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.Part;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.StringPart;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.part.ByteArrayMultipartPart;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.part.FileMultipartPart;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.part.InputStreamMultipartPart;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.part.MessageEndMultipartPart;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.part.MultipartPart;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.part.StringMultipartPart;
import play.shaded.ahc.org.asynchttpclient.util.Assertions;
import play.shaded.ahc.org.asynchttpclient.util.HttpUtils;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;

public class MultipartUtils {
    public static MultipartBody newMultipartBody(List<Part> parts, HttpHeaders requestHeaders) {
        byte[] boundary;
        String contentType2;
        Assertions.assertNotNull(parts, "parts");
        String contentTypeHeader = requestHeaders.get(HttpHeaderNames.CONTENT_TYPE);
        if (MiscUtils.isNonEmpty(contentTypeHeader)) {
            int boundaryLocation = contentTypeHeader.indexOf("boundary=");
            if (boundaryLocation != -1) {
                contentType2 = contentTypeHeader;
                boundary = contentTypeHeader.substring(boundaryLocation + "boundary=".length()).trim().getBytes(StandardCharsets.US_ASCII);
            } else {
                boundary = HttpUtils.computeMultipartBoundary();
                contentType2 = HttpUtils.patchContentTypeWithBoundaryAttribute(contentTypeHeader, boundary);
            }
        } else {
            boundary = HttpUtils.computeMultipartBoundary();
            contentType2 = HttpUtils.patchContentTypeWithBoundaryAttribute(HttpHeaderValues.MULTIPART_FORM_DATA, boundary);
        }
        List<MultipartPart<? extends Part>> multipartParts = MultipartUtils.generateMultipartParts(parts, boundary);
        return new MultipartBody(multipartParts, contentType2, boundary);
    }

    public static List<MultipartPart<? extends Part>> generateMultipartParts(List<Part> parts, byte[] boundary) {
        ArrayList<MultipartPart<? extends Part>> multipartParts = new ArrayList<MultipartPart<? extends Part>>(parts.size());
        for (Part part : parts) {
            if (part instanceof FilePart) {
                multipartParts.add(new FileMultipartPart((FilePart)part, boundary));
                continue;
            }
            if (part instanceof ByteArrayPart) {
                multipartParts.add(new ByteArrayMultipartPart((ByteArrayPart)part, boundary));
                continue;
            }
            if (part instanceof StringPart) {
                multipartParts.add(new StringMultipartPart((StringPart)part, boundary));
                continue;
            }
            if (part instanceof InputStreamPart) {
                multipartParts.add(new InputStreamMultipartPart((InputStreamPart)part, boundary));
                continue;
            }
            throw new IllegalArgumentException("Unknown part type: " + part);
        }
        multipartParts.add(new MessageEndMultipartPart(boundary));
        return multipartParts;
    }
}

