/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.request.body.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.activation.MimetypesFileTypeMap;
import play.shaded.ahc.org.asynchttpclient.request.body.multipart.PartBase;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;

public abstract class FileLikePart
extends PartBase {
    private static final MimetypesFileTypeMap MIME_TYPES_FILE_TYPE_MAP;
    private String fileName;

    public FileLikePart(String name, String contentType2, Charset charset, String fileName, String contentId, String transfertEncoding) {
        super(name, FileLikePart.computeContentType(contentType2, fileName), charset, contentId, transfertEncoding);
        this.fileName = fileName;
    }

    private static String computeContentType(String contentType2, String fileName) {
        return contentType2 != null ? contentType2 : MIME_TYPES_FILE_TYPE_MAP.getContentType(MiscUtils.withDefault(fileName, ""));
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String toString() {
        return super.toString() + " filename=" + this.fileName;
    }

    static {
        try (InputStream is = FileLikePart.class.getResourceAsStream("ahc-mime.types");){
            MIME_TYPES_FILE_TYPE_MAP = new MimetypesFileTypeMap(is);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

