/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.request.body.generator;

import java.util.Queue;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.org.asynchttpclient.request.body.Body;
import play.shaded.ahc.org.asynchttpclient.request.body.generator.BodyChunk;

public final class PushBody
implements Body {
    private final Queue<BodyChunk> queue;
    private Body.BodyState state = Body.BodyState.CONTINUE;

    public PushBody(Queue<BodyChunk> queue2) {
        this.queue = queue2;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public Body.BodyState transferTo(ByteBuf target) {
        switch (this.state) {
            case CONTINUE: {
                return this.readNextChunk(target);
            }
            case STOP: {
                return Body.BodyState.STOP;
            }
        }
        throw new IllegalStateException("Illegal process state.");
    }

    private Body.BodyState readNextChunk(ByteBuf target) {
        Body.BodyState res = Body.BodyState.SUSPEND;
        while (target.isWritable() && this.state != Body.BodyState.STOP) {
            BodyChunk nextChunk = this.queue.peek();
            if (nextChunk == null) {
                return res;
            }
            if (!nextChunk.buffer.isReadable() && !nextChunk.last) {
                this.queue.remove();
                continue;
            }
            res = Body.BodyState.CONTINUE;
            this.readChunk(target, nextChunk);
        }
        return res;
    }

    private void readChunk(ByteBuf target, BodyChunk part) {
        target.writeBytes(part.buffer);
        if (!part.buffer.isReadable()) {
            if (part.last) {
                this.state = Body.BodyState.STOP;
            }
            this.queue.remove();
        }
    }

    @Override
    public void close() {
    }
}

