/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.Unpooled;
import play.shaded.ahc.io.netty.util.CharsetUtil;
import play.shaded.ahc.org.asynchttpclient.netty.util.Utf8ByteBufCharsetDecoder;

public final class ByteBufUtils {
    private static final char[] EMPTY_CHARS = new char[0];
    private static final ThreadLocal<CharBuffer> CHAR_BUFFERS = ThreadLocal.withInitial(() -> CharBuffer.allocate(1024));

    private ByteBufUtils() {
    }

    public static byte[] byteBuf2Bytes(ByteBuf buf) {
        byte[] array2;
        int readable = buf.readableBytes();
        int readerIndex = buf.readerIndex();
        if (buf.hasArray()) {
            array2 = buf.array();
            if (buf.arrayOffset() == 0 && readerIndex == 0 && array2.length == readable) {
                return array2;
            }
        }
        array2 = new byte[readable];
        buf.getBytes(readerIndex, array2);
        return array2;
    }

    public static String byteBuf2String(Charset charset, ByteBuf buf) {
        return ByteBufUtils.isUtf8OrUsAscii(charset) ? Utf8ByteBufCharsetDecoder.decodeUtf8(buf) : buf.toString(charset);
    }

    public static String byteBuf2String(Charset charset, ByteBuf ... bufs) {
        return ByteBufUtils.isUtf8OrUsAscii(charset) ? Utf8ByteBufCharsetDecoder.decodeUtf8(bufs) : ByteBufUtils.byteBuf2String0(charset, bufs);
    }

    public static char[] byteBuf2Chars(Charset charset, ByteBuf buf) {
        return ByteBufUtils.isUtf8OrUsAscii(charset) ? Utf8ByteBufCharsetDecoder.decodeUtf8Chars(buf) : ByteBufUtils.decodeChars(buf, charset);
    }

    public static char[] byteBuf2Chars(Charset charset, ByteBuf ... bufs) {
        return ByteBufUtils.isUtf8OrUsAscii(charset) ? Utf8ByteBufCharsetDecoder.decodeUtf8Chars(bufs) : ByteBufUtils.byteBuf2Chars0(charset, bufs);
    }

    private static boolean isUtf8OrUsAscii(Charset charset) {
        return charset.equals(StandardCharsets.UTF_8) || charset.equals(StandardCharsets.US_ASCII);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] decodeChars(ByteBuf src, Charset charset) {
        int readerIndex = src.readerIndex();
        int len2 = src.readableBytes();
        if (len2 == 0) {
            return EMPTY_CHARS;
        }
        CharsetDecoder decoder = CharsetUtil.decoder(charset);
        int maxLength = (int)((double)len2 * (double)decoder.maxCharsPerByte());
        CharBuffer dst = CHAR_BUFFERS.get();
        if (dst.length() < maxLength) {
            dst = CharBuffer.allocate(maxLength);
            CHAR_BUFFERS.set(dst);
        } else {
            dst.clear();
        }
        if (src.nioBufferCount() == 1) {
            ByteBufUtils.decode(decoder, src.internalNioBuffer(readerIndex, len2), dst);
        } else {
            ByteBuf buffer = src.alloc().heapBuffer(len2);
            try {
                buffer.writeBytes(src, readerIndex, len2);
                ByteBufUtils.decode(decoder, buffer.internalNioBuffer(buffer.readerIndex(), len2), dst);
            }
            finally {
                buffer.release();
            }
        }
        dst.flip();
        return ByteBufUtils.toCharArray(dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String byteBuf2String0(Charset charset, ByteBuf ... bufs) {
        if (bufs.length == 1) {
            return bufs[0].toString(charset);
        }
        ByteBuf composite = ByteBufUtils.composite(bufs);
        try {
            String string2 = composite.toString(charset);
            return string2;
        }
        finally {
            composite.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static char[] byteBuf2Chars0(Charset charset, ByteBuf ... bufs) {
        if (bufs.length == 1) {
            return ByteBufUtils.decodeChars(bufs[0], charset);
        }
        ByteBuf composite = ByteBufUtils.composite(bufs);
        try {
            char[] cArray = ByteBufUtils.decodeChars(composite, charset);
            return cArray;
        }
        finally {
            composite.release();
        }
    }

    private static ByteBuf composite(ByteBuf[] bufs) {
        for (ByteBuf buf : bufs) {
            buf.retain();
        }
        return Unpooled.wrappedBuffer(bufs);
    }

    private static void decode(CharsetDecoder decoder, ByteBuffer src, CharBuffer dst) {
        try {
            CoderResult cr = decoder.decode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = decoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
    }

    static char[] toCharArray(CharBuffer charBuffer) {
        char[] chars = new char[charBuffer.remaining()];
        charBuffer.get(chars);
        return chars;
    }
}

