/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.timeout;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import play.shaded.ahc.io.netty.util.Timeout;
import play.shaded.ahc.io.netty.util.Timer;
import play.shaded.ahc.io.netty.util.TimerTask;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import play.shaded.ahc.org.asynchttpclient.netty.timeout.ReadTimeoutTimerTask;
import play.shaded.ahc.org.asynchttpclient.netty.timeout.RequestTimeoutTimerTask;
import play.shaded.ahc.org.asynchttpclient.util.DateUtils;

public class TimeoutsHolder {
    private final Timeout requestTimeout;
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final Timer nettyTimer;
    private final NettyRequestSender requestSender;
    private final long requestTimeoutMillisTime;
    private final int readTimeoutValue;
    private volatile Timeout readTimeout;
    private volatile NettyResponseFuture<?> nettyResponseFuture;
    private volatile InetSocketAddress remoteAddress;

    public TimeoutsHolder(Timer nettyTimer, NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, AsyncHttpClientConfig config, InetSocketAddress originalRemoteAddress) {
        this.nettyTimer = nettyTimer;
        this.nettyResponseFuture = nettyResponseFuture;
        this.requestSender = requestSender;
        this.remoteAddress = originalRemoteAddress;
        Request targetRequest = nettyResponseFuture.getTargetRequest();
        int readTimeoutInMs = targetRequest.getReadTimeout();
        this.readTimeoutValue = readTimeoutInMs == 0 ? config.getReadTimeout() : readTimeoutInMs;
        int requestTimeoutInMs = targetRequest.getRequestTimeout();
        if (requestTimeoutInMs == 0) {
            requestTimeoutInMs = config.getRequestTimeout();
        }
        if (requestTimeoutInMs != -1) {
            this.requestTimeoutMillisTime = DateUtils.unpreciseMillisTime() + (long)requestTimeoutInMs;
            this.requestTimeout = this.newTimeout(new RequestTimeoutTimerTask(nettyResponseFuture, requestSender, this, requestTimeoutInMs), requestTimeoutInMs);
        } else {
            this.requestTimeoutMillisTime = -1L;
            this.requestTimeout = null;
        }
    }

    public void setResolvedRemoteAddress(InetSocketAddress address) {
        this.remoteAddress = address;
    }

    InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public void startReadTimeout() {
        if (this.readTimeoutValue != -1) {
            this.startReadTimeout(null);
        }
    }

    void startReadTimeout(ReadTimeoutTimerTask task2) {
        if (this.requestTimeout == null || !this.requestTimeout.isExpired() && (long)this.readTimeoutValue < this.requestTimeoutMillisTime - DateUtils.unpreciseMillisTime()) {
            if (task2 == null) {
                task2 = new ReadTimeoutTimerTask(this.nettyResponseFuture, this.requestSender, this, this.readTimeoutValue);
            }
            this.readTimeout = this.newTimeout(task2, this.readTimeoutValue);
        } else if (task2 != null) {
            task2.clean();
        }
    }

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            if (this.requestTimeout != null) {
                this.requestTimeout.cancel();
                ((RequestTimeoutTimerTask)RequestTimeoutTimerTask.class.cast(this.requestTimeout.task())).clean();
            }
            if (this.readTimeout != null) {
                this.readTimeout.cancel();
                ((ReadTimeoutTimerTask)ReadTimeoutTimerTask.class.cast(this.readTimeout.task())).clean();
            }
        }
    }

    private Timeout newTimeout(TimerTask task2, long delay2) {
        return this.requestSender.isClosed() ? null : this.nettyTimer.newTimeout(task2, delay2, TimeUnit.MILLISECONDS);
    }
}

