/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.request.body;

import play.shaded.ahc.io.netty.channel.Channel;
import play.shaded.ahc.io.netty.channel.ChannelProgressiveFuture;
import play.shaded.ahc.io.netty.handler.codec.http.LastHttpContent;
import play.shaded.ahc.io.netty.handler.stream.ChunkedWriteHandler;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.channel.ChannelManager;
import play.shaded.ahc.org.asynchttpclient.netty.request.WriteProgressListener;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.BodyChunkedInput;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.BodyFileRegion;
import play.shaded.ahc.org.asynchttpclient.netty.request.body.NettyBody;
import play.shaded.ahc.org.asynchttpclient.request.body.Body;
import play.shaded.ahc.org.asynchttpclient.request.body.RandomAccessBody;
import play.shaded.ahc.org.asynchttpclient.request.body.generator.BodyGenerator;
import play.shaded.ahc.org.asynchttpclient.request.body.generator.FeedListener;
import play.shaded.ahc.org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import play.shaded.ahc.org.asynchttpclient.request.body.generator.ReactiveStreamsBodyGenerator;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;

public class NettyBodyBody
implements NettyBody {
    private final Body body;
    private final AsyncHttpClientConfig config;

    public NettyBodyBody(Body body2, AsyncHttpClientConfig config) {
        this.body = body2;
        this.config = config;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public long getContentLength() {
        return this.body.getContentLength();
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future2) {
        Object msg;
        if (this.body instanceof RandomAccessBody && !ChannelManager.isSslHandlerConfigured(channel.pipeline()) && !this.config.isDisableZeroCopy() && this.getContentLength() > 0L) {
            msg = new BodyFileRegion((RandomAccessBody)this.body);
        } else {
            msg = new BodyChunkedInput(this.body);
            BodyGenerator bg = future2.getTargetRequest().getBodyGenerator();
            if (bg instanceof FeedableBodyGenerator && !(bg instanceof ReactiveStreamsBodyGenerator)) {
                final ChunkedWriteHandler chunkedWriteHandler = channel.pipeline().get(ChunkedWriteHandler.class);
                ((FeedableBodyGenerator)FeedableBodyGenerator.class.cast(bg)).setListener(new FeedListener(){

                    @Override
                    public void onContentAdded() {
                        chunkedWriteHandler.resumeTransfer();
                    }

                    @Override
                    public void onError(Throwable t) {
                    }
                });
            }
        }
        channel.write(msg, channel.newProgressivePromise()).addListener(new WriteProgressListener(future2, false, this.getContentLength()){

            @Override
            public void operationComplete(ChannelProgressiveFuture cf) {
                MiscUtils.closeSilently(NettyBodyBody.this.body);
                super.operationComplete(cf);
            }
        });
        channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT, channel.voidPromise());
    }
}

