/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.request.body;

import play.shaded.ahc.io.netty.buffer.ByteBuf;
import play.shaded.ahc.io.netty.buffer.ByteBufAllocator;
import play.shaded.ahc.io.netty.channel.ChannelHandlerContext;
import play.shaded.ahc.io.netty.handler.stream.ChunkedInput;
import play.shaded.ahc.org.asynchttpclient.request.body.Body;
import play.shaded.ahc.org.asynchttpclient.util.Assertions;

public class BodyChunkedInput
implements ChunkedInput<ByteBuf> {
    public static final int DEFAULT_CHUNK_SIZE = 8192;
    private final Body body;
    private final int chunkSize;
    private final long contentLength;
    private boolean endOfInput;
    private long progress = 0L;

    BodyChunkedInput(Body body2) {
        this.body = Assertions.assertNotNull(body2, "body");
        this.contentLength = body2.getContentLength();
        this.chunkSize = this.contentLength <= 0L ? 8192 : (int)Math.min(this.contentLength, 8192L);
    }

    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    @Override
    public ByteBuf readChunk(ByteBufAllocator alloc) throws Exception {
        if (this.endOfInput) {
            return null;
        }
        ByteBuf buffer = alloc.buffer(this.chunkSize);
        Body.BodyState state2 = this.body.transferTo(buffer);
        this.progress += (long)buffer.writerIndex();
        switch (state2) {
            case STOP: {
                this.endOfInput = true;
                return buffer;
            }
            case SUSPEND: {
                buffer.release();
                return null;
            }
            case CONTINUE: {
                return buffer;
            }
        }
        throw new IllegalStateException("Unknown state: " + (Object)((Object)state2));
    }

    @Override
    public boolean isEndOfInput() {
        return this.endOfInput;
    }

    @Override
    public void close() throws Exception {
        this.body.close();
    }

    @Override
    public long length() {
        return this.contentLength;
    }

    @Override
    public long progress() {
        return this.progress;
    }
}

